/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.math.voronoi;

import com.gildedgames.aether.common.math.delaunay.Point;
import com.gildedgames.aether.common.math.delaunay.Site;
import com.gildedgames.aether.common.math.delaunay.Voronoi;
import java.util.ArrayList;
import java.util.List;

public class VoronoiGraphUtils {
    public static Voronoi lloydRelax(Voronoi v, int numLloydRelaxations) {
        for (int i = 0; i < numLloydRelaxations; ++i) {
            List<Site> sites = v.getSites();
            ArrayList<Point> points = new ArrayList<Point>(sites.size());
            for (Site site : sites) {
                ArrayList<Point> region = v.region(site);
                double x = 0.0;
                double y = 0.0;
                for (Point c : region) {
                    x += c.x;
                    y += c.y;
                }
                site.x = x /= (double)region.size();
                site.y = y /= (double)region.size();
                points.add(site);
            }
            v = new Voronoi(points, v.getPlotBounds());
        }
        return v;
    }
}

