/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.math.delaunay;

import com.gildedgames.aether.common.math.delaunay.LeftRight;
import com.gildedgames.aether.common.math.delaunay.LeftRightPair;
import com.gildedgames.aether.common.math.delaunay.LineSegment;
import com.gildedgames.aether.common.math.delaunay.Point;
import com.gildedgames.aether.common.math.delaunay.Rectangle;
import com.gildedgames.aether.common.math.delaunay.Site;
import com.gildedgames.aether.common.math.delaunay.Vertex;

public final class VoronoiEdge {
    static final VoronoiEdge DELETED = new VoronoiEdge(0.0, 0.0, 0.0);
    public final double a;
    public final double b;
    public final double c;
    private final LeftRightPair<Vertex> vertices = new LeftRightPair();
    private final LeftRightPair<Point> clippedVertices;
    private final LeftRightPair<Site> sites = new LeftRightPair();

    private VoronoiEdge(double a, double b, double c) {
        this.clippedVertices = new LeftRightPair();
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public static VoronoiEdge createBisectingEdge(Site site0, Site site1) {
        double b;
        double a;
        double dx = site1.x - site0.x;
        double dy = site1.y - site0.y;
        double absdx = dx > 0.0 ? dx : -dx;
        double absdy = dy > 0.0 ? dy : -dy;
        double c = site0.x * dx + site0.y * dy + (dx * dx + dy * dy) * 0.5;
        if (absdx > absdy) {
            a = 1.0;
            b = dy / dx;
            c /= dx;
        } else {
            b = 1.0;
            a = dx / dy;
            c /= dy;
        }
        VoronoiEdge edge = new VoronoiEdge(a, b, c);
        edge.setLeftSite(site0);
        edge.setRightSite(site1);
        site0.addEdge(edge);
        site1.addEdge(edge);
        return edge;
    }

    private static double compareSitesDistances_MAX(VoronoiEdge edge0, VoronoiEdge edge1) {
        double length0 = edge0.sitesDistanceSq();
        double length1 = edge1.sitesDistanceSq();
        return Double.compare(length1, length0);
    }

    public static double compareSitesDistances(VoronoiEdge edge0, VoronoiEdge edge1) {
        return -VoronoiEdge.compareSitesDistances_MAX(edge0, edge1);
    }

    public LineSegment delaunayLine() {
        return new LineSegment(this.getLeftSite(), this.getRightSite());
    }

    public LineSegment voronoiEdge() {
        if (!this.getVisible()) {
            return new LineSegment(null, null);
        }
        return new LineSegment(this.clippedVertices.getLeft(), this.clippedVertices.getRight());
    }

    public Vertex getLeftVertex() {
        return this.vertices.getLeft();
    }

    public Vertex getRightVertex() {
        return this.vertices.getRight();
    }

    public void setVertex(LeftRight leftRight, Vertex v) {
        this.vertices.put(leftRight, v);
    }

    public boolean isPartOfConvexHull() {
        return this.vertices.getLeft() == null || this.vertices.getRight() == null;
    }

    private double sitesDistanceSq() {
        return Point.distanceSq(this.getLeftSite(), this.getRightSite());
    }

    public LeftRightPair<Point> getClippedEnds() {
        return this.clippedVertices;
    }

    public boolean getVisible() {
        return this.clippedVertices.getLeft() != null && this.clippedVertices.getRight() != null;
    }

    public Site getLeftSite() {
        return this.sites.getLeft();
    }

    private void setLeftSite(Site s) {
        this.sites.setLeft(s);
    }

    public Site getRightSite() {
        return this.sites.getRight();
    }

    private void setRightSite(Site s) {
        this.sites.setRight(s);
    }

    public Site getSite(LeftRight leftRight) {
        return this.sites.get(leftRight);
    }

    public void clipVertices(Rectangle bounds) {
        double x1;
        double y1;
        double x0;
        double y0;
        Vertex vertex1;
        Vertex vertex0;
        double xmin = bounds.x;
        double ymin = bounds.y;
        double xmax = bounds.right;
        double ymax = bounds.bottom;
        if (this.a == 1.0 && this.b >= 0.0) {
            vertex0 = this.vertices.getRight();
            vertex1 = this.vertices.getLeft();
        } else {
            vertex0 = this.vertices.getLeft();
            vertex1 = this.vertices.getRight();
        }
        if (this.a == 1.0) {
            y0 = ymin;
            if (vertex0 != null && vertex0.y > ymin) {
                y0 = vertex0.y;
            }
            if (y0 > ymax) {
                return;
            }
            x0 = this.c - this.b * y0;
            y1 = ymax;
            if (vertex1 != null && vertex1.y < ymax) {
                y1 = vertex1.y;
            }
            if (y1 < ymin) {
                return;
            }
            x1 = this.c - this.b * y1;
            if (x0 > xmax && x1 > xmax || x0 < xmin && x1 < xmin) {
                return;
            }
            if (x0 > xmax) {
                x0 = xmax;
                y0 = (this.c - x0) / this.b;
            } else if (x0 < xmin) {
                x0 = xmin;
                y0 = (this.c - x0) / this.b;
            }
            if (x1 > xmax) {
                x1 = xmax;
                y1 = (this.c - x1) / this.b;
            } else if (x1 < xmin) {
                x1 = xmin;
                y1 = (this.c - x1) / this.b;
            }
        } else {
            x0 = xmin;
            if (vertex0 != null && vertex0.x > xmin) {
                x0 = vertex0.x;
            }
            if (x0 > xmax) {
                return;
            }
            y0 = this.c - this.a * x0;
            x1 = xmax;
            if (vertex1 != null && vertex1.x < xmax) {
                x1 = vertex1.x;
            }
            if (x1 < xmin) {
                return;
            }
            y1 = this.c - this.a * x1;
            if (y0 > ymax && y1 > ymax || y0 < ymin && y1 < ymin) {
                return;
            }
            if (y0 > ymax) {
                y0 = ymax;
                x0 = (this.c - y0) / this.a;
            } else if (y0 < ymin) {
                y0 = ymin;
                x0 = (this.c - y0) / this.a;
            }
            if (y1 > ymax) {
                y1 = ymax;
                x1 = (this.c - y1) / this.a;
            } else if (y1 < ymin) {
                y1 = ymin;
                x1 = (this.c - y1) / this.a;
            }
        }
        if (vertex0 == this.vertices.getLeft()) {
            this.clippedVertices.setLeft(new Point(x0, y0));
            this.clippedVertices.setRight(new Point(x1, y1));
        } else {
            this.clippedVertices.setRight(new Point(x0, y0));
            this.clippedVertices.setLeft(new Point(x1, y1));
        }
    }
}

