/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.math.delaunay;

import com.gildedgames.aether.common.math.delaunay.EdgeList;
import com.gildedgames.aether.common.math.delaunay.HalfEdge;
import com.gildedgames.aether.common.math.delaunay.HalfEdgePriorityQueue;
import com.gildedgames.aether.common.math.delaunay.LeftRight;
import com.gildedgames.aether.common.math.delaunay.Point;
import com.gildedgames.aether.common.math.delaunay.Rectangle;
import com.gildedgames.aether.common.math.delaunay.Site;
import com.gildedgames.aether.common.math.delaunay.SiteList;
import com.gildedgames.aether.common.math.delaunay.Vertex;
import com.gildedgames.aether.common.math.delaunay.VoronoiEdge;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class Voronoi {
    private SiteList sites;
    private ArrayList<VoronoiEdge> edges;
    private Rectangle plotBounds;

    public Voronoi(List<Point> points, Rectangle plotBounds) {
        this.init(points, plotBounds);
        this.fortunesAlgorithm();
    }

    public Voronoi(int numSites, Random r, Rectangle plotBounds) {
        ArrayList<Point> points = new ArrayList<Point>(numSites);
        for (int i = 0; i < numSites; ++i) {
            points.add(new Point(plotBounds.x + r.nextDouble() * plotBounds.width, plotBounds.y + r.nextDouble() * plotBounds.height));
        }
        this.init(points, plotBounds);
        this.fortunesAlgorithm();
    }

    public static int compareByYThenX(Site s1, Site s2) {
        return Double.compare(s1.y, s2.y);
    }

    private static int compareByYThenX(Site s1, Point s2) {
        return Double.compare(s1.y, s2.y);
    }

    public Rectangle getPlotBounds() {
        return this.plotBounds;
    }

    private void init(List<Point> points, Rectangle plotBounds) {
        this.sites = new SiteList();
        this.addSites(points);
        this.plotBounds = plotBounds;
        this.edges = new ArrayList();
    }

    private void addSites(List<Point> points) {
        int length = points.size();
        for (int i = 0; i < length; ++i) {
            this.addSite(points.get(i), i);
        }
    }

    private void addSite(Point p, int index) {
        Site site = new Site(p, index);
        this.sites.push(site);
    }

    public ArrayList<VoronoiEdge> edges() {
        return this.edges;
    }

    public ArrayList<Point> region(Site site) {
        return site.region(this.plotBounds);
    }

    public Site[] neighborSitesForSite(Site site) {
        return site.neighborSites();
    }

    public List<Site> getSites() {
        return this.sites.getInner();
    }

    private void fortunesAlgorithm() {
        Rectangle dataBounds = this.sites.getSitesBounds();
        int sqrtnsites = (int)Math.sqrt(this.sites.getSize() + 4);
        HalfEdgePriorityQueue heap = new HalfEdgePriorityQueue(dataBounds.y, dataBounds.height, sqrtnsites);
        EdgeList edgeList = new EdgeList(dataBounds.x, dataBounds.width, sqrtnsites);
        ArrayDeque<Site> sortedSites = this.sites.getSortedQueue();
        Site bottomMostSite = sortedSites.poll();
        Site newSite = sortedSites.poll();
        Point newintstar = null;
        while (true) {
            HalfEdge lbnd;
            if (!heap.empty()) {
                newintstar = heap.min();
            }
            if (newSite != null && (heap.empty() || Voronoi.compareByYThenX(newSite, newintstar) < 0)) {
                lbnd = edgeList.edgeListLeftNeighbor(newSite);
                HalfEdge rbnd = lbnd.edgeListRightNeighbor;
                Site bottomSite = this.rightRegion(lbnd, bottomMostSite);
                VoronoiEdge edge = VoronoiEdge.createBisectingEdge(bottomSite, newSite);
                this.edges.add(edge);
                HalfEdge bisector = new HalfEdge(edge, LeftRight.LEFT);
                edgeList.insert(lbnd, bisector);
                Vertex vertex = Vertex.intersect(lbnd, bisector);
                if (vertex != null) {
                    heap.remove(lbnd);
                    lbnd.vertex = vertex;
                    lbnd.ystar = vertex.y + newSite.dist(vertex);
                    heap.insert(lbnd);
                }
                lbnd = bisector;
                bisector = new HalfEdge(edge, LeftRight.RIGHT);
                edgeList.insert(lbnd, bisector);
                vertex = Vertex.intersect(bisector, rbnd);
                if (vertex != null) {
                    bisector.vertex = vertex;
                    bisector.ystar = vertex.y + newSite.dist(vertex);
                    heap.insert(bisector);
                }
                newSite = sortedSites.poll();
                continue;
            }
            if (heap.empty()) break;
            lbnd = heap.extractMin();
            HalfEdge llbnd = lbnd.edgeListLeftNeighbor;
            HalfEdge rbnd = lbnd.edgeListRightNeighbor;
            HalfEdge rrbnd = rbnd.edgeListRightNeighbor;
            Site bottomSite = this.leftRegion(lbnd, bottomMostSite);
            Site topSite = this.rightRegion(rbnd, bottomMostSite);
            Vertex v = lbnd.vertex;
            lbnd.edge.setVertex(lbnd.leftRight, v);
            rbnd.edge.setVertex(rbnd.leftRight, v);
            edgeList.remove(lbnd);
            heap.remove(rbnd);
            edgeList.remove(rbnd);
            LeftRight leftRight = LeftRight.LEFT;
            if (bottomSite.y > topSite.y) {
                Site tempSite = bottomSite;
                bottomSite = topSite;
                topSite = tempSite;
                leftRight = LeftRight.RIGHT;
            }
            VoronoiEdge edge = VoronoiEdge.createBisectingEdge(bottomSite, topSite);
            this.edges.add(edge);
            HalfEdge bisector = new HalfEdge(edge, leftRight);
            edgeList.insert(llbnd, bisector);
            edge.setVertex(leftRight.other(), v);
            Vertex vertex = Vertex.intersect(llbnd, bisector);
            if (vertex != null) {
                heap.remove(llbnd);
                llbnd.vertex = vertex;
                llbnd.ystar = vertex.y + bottomSite.dist(vertex);
                heap.insert(llbnd);
            }
            if ((vertex = Vertex.intersect(bisector, rrbnd)) == null) continue;
            bisector.vertex = vertex;
            bisector.ystar = vertex.y + bottomSite.dist(vertex);
            heap.insert(bisector);
        }
        for (VoronoiEdge e : this.edges) {
            e.clipVertices(this.plotBounds);
        }
    }

    private Site leftRegion(HalfEdge he, Site site) {
        VoronoiEdge edge = he.edge;
        if (edge == null) {
            return site;
        }
        return edge.getSite(he.leftRight);
    }

    private Site rightRegion(HalfEdge he, Site site) {
        VoronoiEdge edge = he.edge;
        if (edge == null) {
            return site;
        }
        return edge.getSite(he.leftRight.other());
    }
}

