/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.math.delaunay;

import com.gildedgames.aether.common.math.delaunay.HalfEdge;
import com.gildedgames.aether.common.math.delaunay.LeftRight;
import com.gildedgames.aether.common.math.delaunay.Point;
import com.gildedgames.aether.common.math.delaunay.Voronoi;
import com.gildedgames.aether.common.math.delaunay.VoronoiEdge;

final class Vertex
extends Point {
    private Vertex(double x, double y) {
        super(x, y);
    }

    public static Vertex intersect(HalfEdge halfEdge0, HalfEdge halfEdge1) {
        boolean rightOfSite;
        VoronoiEdge edge;
        HalfEdge halfedge;
        VoronoiEdge edge0 = halfEdge0.edge;
        VoronoiEdge edge1 = halfEdge1.edge;
        if (edge0 == null || edge1 == null) {
            return null;
        }
        if (edge0.getRightSite() == edge1.getRightSite()) {
            return null;
        }
        double determinant = edge0.a * edge1.b - edge0.b * edge1.a;
        if (-1.0E-10 < determinant && determinant < 1.0E-10) {
            return null;
        }
        if (Voronoi.compareByYThenX(edge0.getRightSite(), edge1.getRightSite()) < 0) {
            halfedge = halfEdge0;
            edge = edge0;
        } else {
            halfedge = halfEdge1;
            edge = edge1;
        }
        double intersectionX = (edge0.c * edge1.b - edge1.c * edge0.b) / determinant;
        double intersectionY = (edge1.c * edge0.a - edge0.c * edge1.a) / determinant;
        boolean bl = rightOfSite = intersectionX >= edge.getRightSite().x;
        if (rightOfSite && halfedge.leftRight == LeftRight.LEFT || !rightOfSite && halfedge.leftRight == LeftRight.RIGHT) {
            return null;
        }
        return new Vertex(intersectionX, intersectionY);
    }
}

