/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.math.delaunay;

import com.gildedgames.aether.common.math.delaunay.BoundsCheck;
import com.gildedgames.aether.common.math.delaunay.EdgeReorderer;
import com.gildedgames.aether.common.math.delaunay.LeftRight;
import com.gildedgames.aether.common.math.delaunay.Point;
import com.gildedgames.aether.common.math.delaunay.Polygon;
import com.gildedgames.aether.common.math.delaunay.Rectangle;
import com.gildedgames.aether.common.math.delaunay.Vertex;
import com.gildedgames.aether.common.math.delaunay.VoronoiEdge;
import com.gildedgames.aether.common.math.delaunay.Winding;
import java.util.ArrayList;
import java.util.Collections;

public final class Site
extends Point
implements Comparable<Site> {
    private static final double EPSILON = 0.005;
    private ArrayList<VoronoiEdge> edges;
    private int siteIndex;
    private ArrayList<LeftRight> edgeLeftRights;
    private ArrayList<Point> region;

    public Site(Point p, int index) {
        super(p.x, p.y);
        this.siteIndex = index;
        this.edges = new ArrayList();
        this.region = null;
    }

    private static boolean closeEnough(Point p0, Point p1) {
        return Point.distanceSq(p0, p1) < 0.005;
    }

    void addEdge(VoronoiEdge edge) {
        this.edges.add(edge);
    }

    public VoronoiEdge nearestEdge() {
        this.edges.sort((o1, o2) -> (int)VoronoiEdge.compareSitesDistances(o1, o2));
        return this.edges.get(0);
    }

    Site[] neighborSites() {
        if (this.edges == null || this.edges.isEmpty()) {
            return new Site[0];
        }
        if (this.edgeLeftRights == null) {
            this.reorderEdges();
        }
        Site[] list = new Site[this.edges.size()];
        for (int i = 0; i < this.edges.size(); ++i) {
            VoronoiEdge edge = this.edges.get(i);
            list[i] = this.neighborSite(edge);
        }
        return list;
    }

    private Site neighborSite(VoronoiEdge edge) {
        if (this == edge.getLeftSite()) {
            return edge.getRightSite();
        }
        if (this == edge.getRightSite()) {
            return edge.getLeftSite();
        }
        return null;
    }

    ArrayList<Point> region(Rectangle clippingBounds) {
        if (this.edges == null || this.edges.isEmpty()) {
            return new ArrayList<Point>();
        }
        if (this.edgeLeftRights == null) {
            this.reorderEdges();
            this.region = this.clipToBounds(clippingBounds);
            if (Polygon.getWinding(this.region) == Winding.CLOCKWISE) {
                Collections.reverse(this.region);
            }
        }
        return this.region;
    }

    private void reorderEdges() {
        EdgeReorderer reorderer = new EdgeReorderer(this.edges);
        this.edges = reorderer.getEdges();
        this.edgeLeftRights = reorderer.getEdgeLeftRights();
    }

    private ArrayList<Point> clipToBounds(Rectangle bounds) {
        int i;
        int n = this.edges.size();
        for (i = 0; i < n && !this.edges.get(i).getVisible(); ++i) {
        }
        if (i == n) {
            return new ArrayList<Point>();
        }
        VoronoiEdge edge = this.edges.get(i);
        LeftRight leftRight = this.edgeLeftRights.get(i);
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(edge.getClippedEnds().get(leftRight));
        points.add(edge.getClippedEnds().get(leftRight.other()));
        for (int j = i + 1; j < n; ++j) {
            edge = this.edges.get(j);
            if (!edge.getVisible()) continue;
            this.connect(points, j, bounds, false);
        }
        this.connect(points, i, bounds, true);
        return points;
    }

    private void connect(ArrayList<Point> points, int j, Rectangle bounds, boolean closingUp) {
        Point rightPoint = points.get(points.size() - 1);
        VoronoiEdge newEdge = this.edges.get(j);
        LeftRight newLeftRight = this.edgeLeftRights.get(j);
        Point newPoint = newEdge.getClippedEnds().get(newLeftRight);
        if (!Site.closeEnough(rightPoint, newPoint)) {
            if (rightPoint.x != newPoint.x && rightPoint.y != newPoint.y) {
                int rightCheck = BoundsCheck.check(rightPoint, bounds);
                int newCheck = BoundsCheck.check(newPoint, bounds);
                if ((rightCheck & 8) != 0) {
                    double px = bounds.right;
                    if ((newCheck & 2) != 0) {
                        double py = bounds.bottom;
                        points.add(new Point(px, py));
                    } else if ((newCheck & 1) != 0) {
                        double py = bounds.top;
                        points.add(new Point(px, py));
                    } else if ((newCheck & 4) != 0) {
                        double py = rightPoint.y - bounds.y + newPoint.y - bounds.y < bounds.height ? bounds.top : bounds.bottom;
                        points.add(new Point(px, py));
                        points.add(new Point(bounds.left, py));
                    }
                } else if ((rightCheck & 4) != 0) {
                    double px = bounds.left;
                    if ((newCheck & 2) != 0) {
                        double py = bounds.bottom;
                        points.add(new Point(px, py));
                    } else if ((newCheck & 1) != 0) {
                        double py = bounds.top;
                        points.add(new Point(px, py));
                    } else if ((newCheck & 8) != 0) {
                        double py = rightPoint.y - bounds.y + newPoint.y - bounds.y < bounds.height ? bounds.top : bounds.bottom;
                        points.add(new Point(px, py));
                        points.add(new Point(bounds.right, py));
                    }
                } else if ((rightCheck & 1) != 0) {
                    double py = bounds.top;
                    if ((newCheck & 8) != 0) {
                        double px = bounds.right;
                        points.add(new Point(px, py));
                    } else if ((newCheck & 4) != 0) {
                        double px = bounds.left;
                        points.add(new Point(px, py));
                    } else if ((newCheck & 2) != 0) {
                        double px = rightPoint.x - bounds.x + newPoint.x - bounds.x < bounds.width ? bounds.left : bounds.right;
                        points.add(new Point(px, py));
                        points.add(new Point(px, bounds.bottom));
                    }
                } else if ((rightCheck & 2) != 0) {
                    double py = bounds.bottom;
                    if ((newCheck & 8) != 0) {
                        double px = bounds.right;
                        points.add(new Point(px, py));
                    } else if ((newCheck & 4) != 0) {
                        double px = bounds.left;
                        points.add(new Point(px, py));
                    } else if ((newCheck & 1) != 0) {
                        double px = rightPoint.x - bounds.x + newPoint.x - bounds.x < bounds.width ? bounds.left : bounds.right;
                        points.add(new Point(px, py));
                        points.add(new Point(px, bounds.top));
                    }
                }
            }
            if (closingUp) {
                return;
            }
            points.add(newPoint);
        }
        Point newRightPoint = newEdge.getClippedEnds().get(newLeftRight.other());
        if (!Site.closeEnough(points.get(0), newRightPoint)) {
            points.add(newRightPoint);
        }
    }

    public double dist(Vertex p) {
        return Point.distance(p, this);
    }

    @Override
    public int compareTo(Site other) {
        if (this.y < other.y) {
            if (this.siteIndex > other.siteIndex) {
                int tempIndex = this.siteIndex;
                this.siteIndex = other.siteIndex;
                other.siteIndex = tempIndex;
            }
            return -1;
        }
        if (this.y > other.y) {
            if (other.siteIndex > this.siteIndex) {
                int tempIndex = other.siteIndex;
                other.siteIndex = this.siteIndex;
                this.siteIndex = tempIndex;
            }
            return 1;
        }
        return 0;
    }
}

