/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.math.delaunay;

import com.gildedgames.aether.common.math.delaunay.Point;
import com.gildedgames.aether.common.math.delaunay.Winding;
import java.util.ArrayList;

public final class Polygon {
    public static Winding getWinding(ArrayList<Point> vertices) {
        double signedDoubleArea = Polygon.signedDoubleArea(vertices);
        if (signedDoubleArea < 0.0) {
            return Winding.CLOCKWISE;
        }
        if (signedDoubleArea > 0.0) {
            return Winding.COUNTERCLOCKWISE;
        }
        return Winding.NONE;
    }

    private static double signedDoubleArea(ArrayList<Point> vertices) {
        int n = vertices.size();
        double signedDoubleArea = 0.0;
        for (int index = 0; index < n; ++index) {
            int nextIndex = (index + 1) % n;
            Point point = vertices.get(index);
            Point next = vertices.get(nextIndex);
            signedDoubleArea += point.x * next.y - next.x * point.y;
        }
        return signedDoubleArea;
    }
}

