/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.math.delaunay;

public class Point {
    public double x;
    public double y;

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static double distanceSq(Point p1, Point p2) {
        return (p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y);
    }

    public static double distance(Point p1, Point p2) {
        return Math.sqrt(Point.distanceSq(p1, p2));
    }

    public static Point interpolate(Point p1, Point p2, double alpha) {
        return new Point(Point.lerp(p1.x, p2.x, alpha), Point.lerp(p1.y, p2.y, alpha));
    }

    public static double lerp(double point1, double point2, double alpha) {
        return point1 + alpha * (point2 - point1);
    }

    public static Point centroid(Point ... points) {
        double centroidX = 0.0;
        double centroidY = 0.0;
        for (Point knot : points) {
            centroidX += knot.x;
            centroidY += knot.y;
        }
        return new Point(centroidX / (double)points.length, centroidY / (double)points.length);
    }

    public static Point subtract(Point p1, Point p2) {
        return new Point(p1.x - p2.x, p1.y - p2.y);
    }

    private static boolean equals(double a, double b, double eps) {
        if (a == b) {
            return true;
        }
        return Math.abs(a - b) < eps;
    }

    public String toString() {
        return this.x + ", " + this.y;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Point) {
            Point p = (Point)obj;
            return Point.equals(p.x, this.x, 1.0E-6) && Point.equals(p.y, this.y, 1.0E-6);
        }
        return false;
    }
}

