/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.math.delaunay;

import com.gildedgames.aether.common.math.delaunay.LeftRight;
import com.gildedgames.aether.common.math.delaunay.Point;
import com.gildedgames.aether.common.math.delaunay.Site;
import com.gildedgames.aether.common.math.delaunay.Vertex;
import com.gildedgames.aether.common.math.delaunay.VoronoiEdge;

public final class HalfEdge {
    public HalfEdge edgeListLeftNeighbor;
    public HalfEdge edgeListRightNeighbor;
    public HalfEdge nextInPriorityQueue;
    public VoronoiEdge edge;
    public final LeftRight leftRight;
    public Vertex vertex;
    public double ystar;

    public HalfEdge(VoronoiEdge edge, LeftRight lr) {
        this.edge = edge;
        this.leftRight = lr;
        this.nextInPriorityQueue = null;
        this.vertex = null;
    }

    public static HalfEdge createDummy() {
        return new HalfEdge(null, null);
    }

    public String toString() {
        return "HalfEdge (leftRight: " + (Object)((Object)this.leftRight) + "; vertex: " + this.vertex + ")";
    }

    public boolean isLeftOf(Point p) {
        boolean above;
        boolean rightOfSite;
        Site topSite = this.edge.getRightSite();
        boolean bl = rightOfSite = p.x > topSite.x;
        if (rightOfSite && this.leftRight == LeftRight.LEFT) {
            return true;
        }
        if (!rightOfSite && this.leftRight == LeftRight.RIGHT) {
            return false;
        }
        if (this.edge.a == 1.0) {
            double dyp = p.y - topSite.y;
            double dxp = p.x - topSite.x;
            boolean fast = false;
            if (!rightOfSite && this.edge.b < 0.0 || rightOfSite && this.edge.b >= 0.0) {
                fast = above = dyp >= this.edge.b * dxp;
            } else {
                boolean bl2 = above = p.x + p.y * this.edge.b > this.edge.c;
                if (this.edge.b < 0.0) {
                    boolean bl3 = above = !above;
                }
                if (!above) {
                    fast = true;
                }
            }
            if (!fast) {
                double dxs = topSite.x - this.edge.getLeftSite().x;
                boolean bl4 = above = this.edge.b * (dxp * dxp - dyp * dyp) < dxs * dyp * (1.0 + 2.0 * dxp / dxs + this.edge.b * this.edge.b);
                if (this.edge.b < 0.0) {
                    above = !above;
                }
            }
        } else {
            double yl = this.edge.c - this.edge.a * p.x;
            double t1 = p.y - yl;
            double t2 = p.x - topSite.x;
            double t3 = yl - topSite.y;
            above = t1 * t1 > t2 * t2 + t3 * t3;
        }
        return this.leftRight == LeftRight.LEFT == above;
    }
}

