/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.math.delaunay;

import com.gildedgames.aether.common.math.delaunay.LeftRight;
import com.gildedgames.aether.common.math.delaunay.Vertex;
import com.gildedgames.aether.common.math.delaunay.VoronoiEdge;
import java.util.ArrayList;

public final class EdgeReorderer {
    private ArrayList<VoronoiEdge> edges;
    private ArrayList<LeftRight> edgeLeftRights;

    public EdgeReorderer(ArrayList<VoronoiEdge> origEdges) {
        if (origEdges.size() > 0) {
            this.reorderEdges(origEdges);
        } else {
            this.edges = new ArrayList();
            this.edgeLeftRights = new ArrayList();
        }
    }

    public ArrayList<VoronoiEdge> getEdges() {
        return this.edges;
    }

    public ArrayList<LeftRight> getEdgeLeftRights() {
        return this.edgeLeftRights;
    }

    private void reorderEdges(ArrayList<VoronoiEdge> origEdges) {
        int n = origEdges.size();
        boolean[] done = new boolean[n];
        ArrayList<VoronoiEdge> newEdges = new ArrayList<VoronoiEdge>(n);
        ArrayList<LeftRight> newLeftRights = new ArrayList<LeftRight>(n);
        int i = 0;
        VoronoiEdge edge = origEdges.get(i);
        newEdges.add(edge);
        newLeftRights.add(LeftRight.LEFT);
        Vertex firstPoint = edge.getLeftVertex();
        Vertex lastPoint = edge.getRightVertex();
        done[i] = true;
        int nDone = 1;
        while (nDone < n) {
            for (i = 1; i < n; ++i) {
                if (done[i]) continue;
                edge = origEdges.get(i);
                Vertex leftPoint = edge.getLeftVertex();
                Vertex rightPoint = edge.getRightVertex();
                boolean created = false;
                if (leftPoint == lastPoint) {
                    lastPoint = rightPoint;
                    newLeftRights.add(LeftRight.LEFT);
                    newEdges.add(edge);
                    created = true;
                } else if (rightPoint == firstPoint) {
                    firstPoint = leftPoint;
                    newLeftRights.add(0, LeftRight.LEFT);
                    newEdges.add(0, edge);
                    created = true;
                } else if (leftPoint == firstPoint) {
                    firstPoint = rightPoint;
                    newLeftRights.add(0, LeftRight.RIGHT);
                    newEdges.add(0, edge);
                    created = true;
                } else if (rightPoint == lastPoint) {
                    lastPoint = leftPoint;
                    newLeftRights.add(LeftRight.RIGHT);
                    newEdges.add(edge);
                    created = true;
                }
                if (!created) continue;
                done[i] = true;
                ++nDone;
            }
        }
        this.edgeLeftRights = newLeftRights;
        this.edges = newEdges;
    }
}

