/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.math.delaunay;

import com.gildedgames.aether.common.math.delaunay.HalfEdge;
import com.gildedgames.aether.common.math.delaunay.Point;
import com.gildedgames.aether.common.math.delaunay.VoronoiEdge;

public final class EdgeList {
    private final double deltaX;
    private final double minX;
    private final int hashSize;
    private final HalfEdge leftEnd;
    private final HalfEdge rightEnd;
    private final HalfEdge[] hash;

    public EdgeList(double xmin, double deltax, int sqrtnsites) {
        this.minX = xmin;
        this.deltaX = deltax;
        this.hashSize = 2 * sqrtnsites;
        this.hash = new HalfEdge[this.hashSize];
        this.leftEnd = HalfEdge.createDummy();
        this.rightEnd = HalfEdge.createDummy();
        this.leftEnd.edgeListLeftNeighbor = null;
        this.leftEnd.edgeListRightNeighbor = this.rightEnd;
        this.rightEnd.edgeListLeftNeighbor = this.leftEnd;
        this.rightEnd.edgeListRightNeighbor = null;
        this.hash[0] = this.leftEnd;
        this.hash[this.hashSize - 1] = this.rightEnd;
    }

    public void insert(HalfEdge lb, HalfEdge newHalfEdge) {
        newHalfEdge.edgeListLeftNeighbor = lb;
        newHalfEdge.edgeListRightNeighbor = lb.edgeListRightNeighbor;
        lb.edgeListRightNeighbor.edgeListLeftNeighbor = newHalfEdge;
        lb.edgeListRightNeighbor = newHalfEdge;
    }

    public void remove(HalfEdge halfEdge) {
        halfEdge.edgeListLeftNeighbor.edgeListRightNeighbor = halfEdge.edgeListRightNeighbor;
        halfEdge.edgeListRightNeighbor.edgeListLeftNeighbor = halfEdge.edgeListLeftNeighbor;
        halfEdge.edge = VoronoiEdge.DELETED;
        halfEdge.edgeListRightNeighbor = null;
        halfEdge.edgeListLeftNeighbor = null;
    }

    public HalfEdge edgeListLeftNeighbor(Point p) {
        HalfEdge halfEdge;
        int bucket = (int)((p.x - this.minX) / this.deltaX * (double)this.hashSize);
        if (bucket < 0) {
            bucket = 0;
        }
        if (bucket >= this.hashSize) {
            bucket = this.hashSize - 1;
        }
        if ((halfEdge = this.getHash(bucket)) == null) {
            int i = 1;
            while ((halfEdge = this.getHash(bucket - i)) == null && (halfEdge = this.getHash(bucket + i)) == null) {
                ++i;
            }
        }
        if (halfEdge == this.leftEnd || halfEdge != this.rightEnd && halfEdge.isLeftOf(p)) {
            while ((halfEdge = halfEdge.edgeListRightNeighbor) != this.rightEnd && halfEdge.isLeftOf(p)) {
            }
            halfEdge = halfEdge.edgeListLeftNeighbor;
        } else {
            while ((halfEdge = halfEdge.edgeListLeftNeighbor) != this.leftEnd && !halfEdge.isLeftOf(p)) {
            }
        }
        if (bucket > 0 && bucket < this.hashSize - 1) {
            this.hash[bucket] = halfEdge;
        }
        return halfEdge;
    }

    private HalfEdge getHash(int b) {
        if (b < 0 || b >= this.hashSize) {
            return null;
        }
        HalfEdge halfEdge = this.hash[b];
        if (halfEdge != null && halfEdge.edge == VoronoiEdge.DELETED) {
            this.hash[b] = null;
            return null;
        }
        return halfEdge;
    }
}

