/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.items.weapons.swords;

import com.gildedgames.aether.api.entity.damage.IDamageLevelsHolder;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.init.CreativeTabsAether;
import com.gildedgames.aether.common.items.ItemAbilityType;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAetherSword
extends ItemSword
implements IDamageLevelsHolder {
    private float slashDamageLevel = 0.0f;
    private float pierceDamageLevel = 0.0f;
    private float impactDamageLevel = 0.0f;
    private final ItemAbilityType abilityType;

    public ItemAetherSword(Item.ToolMaterial material, ItemAbilityType abilityType) {
        super(material);
        this.abilityType = abilityType;
        this.func_77637_a(CreativeTabsAether.TAB_WEAPONS);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (this.abilityType != ItemAbilityType.NONE) {
            tooltip.add(String.format("%s: %s", TextFormatting.BLUE + I18n.func_135052_a((String)"item.aether.tooltip.ability", (Object[])new Object[0]), TextFormatting.WHITE + I18n.func_135052_a((String)(this.func_77658_a() + ".ability.desc"), (Object[])new Object[0])));
            if (!this.abilityType.isPassive()) {
                tooltip.add(String.format("%s: %s", TextFormatting.DARK_AQUA + I18n.func_135052_a((String)"item.aether.tooltip.use", (Object[])new Object[0]), TextFormatting.WHITE + I18n.func_135052_a((String)(this.func_77658_a() + ".use.desc"), (Object[])new Object[0])));
            }
        }
    }

    public int getItemBurnTime(ItemStack itemStack) {
        if (this == ItemsAether.skyroot_sword) {
            return 100;
        }
        return super.getItemBurnTime(itemStack);
    }

    public <T extends ItemAetherSword> T setSlashDamageLevel(float level) {
        this.slashDamageLevel = level;
        return (T)this;
    }

    public <T extends ItemAetherSword> T setPierceDamageLevel(float level) {
        this.pierceDamageLevel = level;
        return (T)this;
    }

    public <T extends ItemAetherSword> T setImpactDamageLevel(float level) {
        this.impactDamageLevel = level;
        return (T)this;
    }

    @Override
    public float getSlashDamageLevel() {
        return this.slashDamageLevel;
    }

    @Override
    public float getPierceDamageLevel() {
        return this.pierceDamageLevel;
    }

    @Override
    public float getImpactDamageLevel() {
        return this.impactDamageLevel;
    }
}

