/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.items.weapons.crossbow;

import com.gildedgames.aether.common.entities.projectiles.EntityBolt;
import com.gildedgames.aether.common.init.CreativeTabsAether;
import com.gildedgames.aether.common.items.weapons.crossbow.ItemBolt;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCrossbow
extends Item {
    private float durationInTicks;
    private float knockBackValue;
    private crossBowTypes cBType;
    private boolean isSpecialLoaded;
    private boolean finishedLoading = false;

    public ItemCrossbow() {
        this.field_77777_bU = 1;
        this.knockBackValue = 0.0f;
        this.durationInTicks = 20.0f;
        this.isSpecialLoaded = false;
        this.func_77637_a(CreativeTabsAether.TAB_WEAPONS);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn != null) {
                    ItemStack activeItemStack = entityIn.func_184607_cu();
                    ItemStack heldItemStack = entityIn.func_184614_ca();
                    float duration = ItemCrossbow.this.isSpecialLoaded ? ItemCrossbow.this.getDurationInTicks() * 2.0f : ItemCrossbow.this.getDurationInTicks();
                    if (heldItemStack == stack && heldItemStack.func_77973_b() == ItemCrossbow.this) {
                        if (entityIn.func_184587_cr() && activeItemStack == stack && activeItemStack.func_77973_b() == ItemCrossbow.this) {
                            return (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / duration;
                        }
                        if (((ItemCrossbow)heldItemStack.func_77973_b()).finishedLoading) {
                            return 1.0f;
                        }
                    }
                }
                return 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn != null) {
                    ItemStack activeItemStack = entityIn.func_184607_cu();
                    ItemStack heldItemStack = entityIn.func_184614_ca();
                    if (heldItemStack == stack && heldItemStack.func_77973_b() == ItemCrossbow.this && entityIn.func_184587_cr() && activeItemStack == stack && activeItemStack.func_77973_b() == ItemCrossbow.this) {
                        return 1.0f;
                    }
                }
                return 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("ready"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && ItemCrossbow.this.finishedLoading ? 1.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("charged"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && ItemCrossbow.isLoaded(stack) ? 1.0f : 0.0f;
            }
        });
    }

    private static void checkTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public static boolean isLoaded(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        ItemCrossbow.checkTag(stack);
        return stack.func_77978_p().func_74767_n("loaded");
    }

    public static void setLoaded(ItemStack stack, boolean loaded) {
        if (stack == null) {
            return;
        }
        ItemCrossbow.checkTag(stack);
        stack.func_77978_p().func_74757_a("loaded", loaded);
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (this.isBolt(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isBolt(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemStack = player.field_71071_by.func_70301_a(i);
            if (!this.isBolt(itemStack)) continue;
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    private boolean hasAmmo(EntityPlayer player) {
        boolean hasBolts;
        ItemStack boltStack = this.findAmmo(player);
        boolean bl = hasBolts = boltStack.func_190916_E() >= 1;
        if (this.cBType == crossBowTypes.SKYROOT && player.func_70093_af()) {
            hasBolts = boltStack.func_190916_E() >= 2;
        } else if (this.cBType == crossBowTypes.HOLYSTONE && player.func_70093_af()) {
            hasBolts = boltStack.func_190916_E() >= 3;
        }
        return this.isBolt(boltStack) && hasBolts;
    }

    private boolean isBolt(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBolt;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!ItemCrossbow.isLoaded(stack)) {
            if (this.hasAmmo(playerIn)) {
                playerIn.func_184598_c(EnumHand.MAIN_HAND);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        } else {
            if (playerIn.field_70170_p.field_72995_K) {
                ItemRenderer renderer = Minecraft.func_71410_x().func_175597_ag();
                renderer.field_187469_f = 1.5f;
            }
            this.shootBolt((EntityLivingBase)playerIn, stack);
            if (!playerIn.field_70170_p.field_72995_K) {
                ItemCrossbow.setLoaded(stack, false);
            }
            playerIn.field_184628_bn = 0;
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private void shootBolt(EntityLivingBase entityLiving, ItemStack stack) {
        if (!entityLiving.field_70170_p.field_72995_K) {
            World world = entityLiving.field_70170_p;
            world.func_184148_a(null, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
            float speed = 1.0f;
            EntityBolt bolt0 = null;
            EntityBolt bolt1 = null;
            EntityBolt bolt2 = null;
            float slashDamageLevel = this.cBType.slashDamageLevel;
            float pierceDamageLevel = this.cBType.pierceDamageLevel;
            float impactDamageLevel = this.cBType.impactDamageLevel;
            float vanillaDamage = this.cBType.damage;
            if (this.isSpecialLoaded && this.cBType != crossBowTypes.ZANITE && this.cBType != crossBowTypes.GRAVETITE) {
                if (this.cBType == crossBowTypes.SKYROOT) {
                    bolt0 = this.createBolt(entityLiving, 1.0f, 0.0f, 0.0f, 0.0f, slashDamageLevel, pierceDamageLevel, impactDamageLevel, vanillaDamage);
                    bolt1 = this.createBolt(entityLiving, 1.0f, 0.0f, 0.0f, 0.0f, slashDamageLevel, pierceDamageLevel, impactDamageLevel, vanillaDamage);
                } else if (this.cBType == crossBowTypes.HOLYSTONE) {
                    bolt0 = this.createBolt(entityLiving, 0.5f, 0.0f, 0.0f, 0.0f, slashDamageLevel, pierceDamageLevel, impactDamageLevel, vanillaDamage);
                    bolt1 = this.createBolt(entityLiving, 0.5f, 10.0f, 0.0f, 0.0f, slashDamageLevel, pierceDamageLevel, impactDamageLevel, vanillaDamage);
                    bolt2 = this.createBolt(entityLiving, 0.5f, -10.0f, 0.0f, 0.0f, slashDamageLevel, pierceDamageLevel, impactDamageLevel, vanillaDamage);
                } else if (this.cBType == crossBowTypes.ARKENIUM) {
                    bolt0 = this.createBolt(entityLiving, 2.5f, 0.0f, -1.0f, 0.0f, slashDamageLevel, pierceDamageLevel, impactDamageLevel, vanillaDamage);
                }
            } else if (this.cBType == crossBowTypes.ZANITE) {
                float bonusPierce = 0.0f;
                if (entityLiving.func_184614_ca() == stack) {
                    vanillaDamage = 6.0f + (float)(stack.func_77952_i() * 4) / (float)stack.func_77973_b().func_77612_l();
                    bonusPierce = (float)(stack.func_77952_i() * 4) / (float)stack.func_77973_b().func_77612_l();
                }
                bolt0 = this.createBolt(entityLiving, 1.0f, 0.0f, 0.0f, 0.0f, slashDamageLevel, pierceDamageLevel + bonusPierce, impactDamageLevel, vanillaDamage);
            } else if (this.cBType == crossBowTypes.GRAVETITE) {
                bolt0 = this.createBolt(entityLiving, 1.0f, 0.0f, 0.0f, 0.0f, slashDamageLevel, pierceDamageLevel, impactDamageLevel, vanillaDamage);
                if (bolt0 != null) {
                    bolt0.func_189654_d(true);
                }
            } else {
                bolt0 = this.createBolt(entityLiving, 1.0f, 0.0f, 0.0f, 0.0f, slashDamageLevel, pierceDamageLevel, impactDamageLevel, vanillaDamage);
            }
            if (entityLiving instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entityLiving;
                if (player.field_71075_bZ.field_75098_d) {
                    if (bolt0 != null) {
                        bolt0.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                    }
                    if (bolt1 != null) {
                        bolt1.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                    }
                    if (bolt2 != null) {
                        bolt2.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                    }
                } else {
                    if (this.getDamage(stack) >= this.getMaxDamage(stack)) {
                        player.field_71071_by.func_184437_d(stack);
                        world.func_184148_a(null, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
                    }
                    if (this.isSpecialLoaded) {
                        this.setDamage(stack, this.getDamage(stack) + 2);
                    } else {
                        this.setDamage(stack, this.getDamage(stack) + 1);
                    }
                }
            }
            if (bolt0 != null) {
                entityLiving.func_130014_f_().func_72838_d((Entity)bolt0);
            }
            if (bolt1 != null) {
                entityLiving.func_130014_f_().func_72838_d(bolt1);
            }
            if (bolt2 != null) {
                entityLiving.func_130014_f_().func_72838_d(bolt2);
            }
            this.isSpecialLoaded = false;
            this.finishedLoading = false;
        }
    }

    private EntityBolt createBolt(EntityLivingBase entityLiving, float speed, float addRotationYaw, float addRotationPitch, float addInaccuracy, float slashDamageLevel, float pierceDamageLevel, float impactDamageLevel, float damage) {
        if (!entityLiving.field_70170_p.field_72995_K) {
            EntityBolt bolt = new EntityBolt(entityLiving.func_130014_f_(), entityLiving);
            bolt.func_184547_a((Entity)entityLiving, entityLiving.field_70125_A + addRotationPitch, entityLiving.field_70177_z + addRotationYaw, 0.0f, speed * 2.0f, 1.0f + addInaccuracy);
            bolt.setSlashDamageLevel(slashDamageLevel);
            bolt.setPierceDamageLevel(pierceDamageLevel);
            bolt.setImpactDamageLevel(impactDamageLevel);
            bolt.func_70239_b(damage / 2.0f);
            bolt.func_70243_d(false);
            bolt.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
            return bolt;
        }
        return null;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        EntityPlayer player;
        if (living instanceof EntityPlayer && this.hasAmmo(player = (EntityPlayer)living) && !living.func_130014_f_().field_72995_K) {
            float duration;
            float use = (float)(this.func_77626_a(stack) - living.func_184605_cv()) / 20.0f;
            if (use == 0.0f) {
                if (this.cBType != crossBowTypes.ZANITE && this.cBType != crossBowTypes.GRAVETITE) {
                    this.isSpecialLoaded = player.func_70093_af();
                }
                this.finishedLoading = false;
            }
            if (use >= (duration = this.isSpecialLoaded ? this.getDurationInTicks() * 2.0f : this.getDurationInTicks()) / 20.0f) {
                this.finishedLoading = true;
            }
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            ItemStack boltStack = this.findAmmo(player);
            this.finishedLoading = false;
            if (this.hasAmmo(player) && !entityLiving.func_130014_f_().field_72995_K) {
                float duration;
                float use = (float)(this.func_77626_a(stack) - entityLiving.func_184605_cv()) / 20.0f;
                if (!player.func_70093_af()) {
                    this.isSpecialLoaded = false;
                }
                if (use >= (duration = this.isSpecialLoaded ? this.getDurationInTicks() * 2.0f : this.getDurationInTicks()) / 20.0f) {
                    ItemCrossbow.setLoaded(stack, true);
                    World world = entityLiving.field_70170_p;
                    world.func_184148_a(null, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, SoundEvents.field_187883_gR, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
                    if (!player.field_71075_bZ.field_75098_d) {
                        int shrinkQuantity = 1;
                        if (this.isSpecialLoaded) {
                            if (this.cBType == crossBowTypes.HOLYSTONE) {
                                shrinkQuantity = 3;
                            }
                            if (this.cBType == crossBowTypes.SKYROOT) {
                                shrinkQuantity = 2;
                            }
                        }
                        boltStack.func_190918_g(shrinkQuantity);
                        if (boltStack.func_190916_E() == 0) {
                            player.field_71071_by.func_184437_d(boltStack);
                        }
                    }
                }
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public boolean func_77651_p() {
        return true;
    }

    public float getKnockBackValue() {
        return this.knockBackValue;
    }

    public ItemCrossbow setKnockBackValue(float x) {
        this.knockBackValue = x;
        return this;
    }

    public float getDurationInTicks() {
        return this.durationInTicks;
    }

    public ItemCrossbow setDurationInTicks(int x) {
        this.durationInTicks = x;
        return this;
    }

    public boolean getIsSpecialLoaded() {
        return this.isSpecialLoaded;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        int n;
        float seconds = this.durationInTicks / 20.0f;
        tooltip.add(String.format("%s: %s", TextFormatting.BLUE + I18n.func_135052_a((String)"item.aether.crossbow.desc4", (Object[])new Object[0]), TextFormatting.WHITE + I18n.func_135052_a((String)("item.aether." + this.cBType.name + ".ability"), (Object[])new Object[0])));
        if (this.cBType != crossBowTypes.ZANITE && this.cBType != crossBowTypes.GRAVETITE) {
            tooltip.add(String.format("%s: %s", TextFormatting.DARK_AQUA + I18n.func_135052_a((String)"item.aether.tooltip.use", (Object[])new Object[0]), TextFormatting.WHITE + I18n.func_135052_a((String)"item.aether.crossbow.use.desc", (Object[])new Object[0])));
        }
        tooltip.add("");
        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"item.modifiers.mainhand", (Object[])new Object[0]));
        if ((double)seconds == Math.floor(seconds)) {
            tooltip.add(TextFormatting.GRAY + " " + (int)Math.floor(seconds) + " " + I18n.func_135052_a((String)"item.aether.crossbow.desc3", (Object[])new Object[0]) + I18n.func_135052_a((String)"item.aether.crossbow.desc1", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.GRAY + " " + seconds + " " + I18n.func_135052_a((String)"item.aether.crossbow.desc3", (Object[])new Object[0]) + I18n.func_135052_a((String)"item.aether.crossbow.desc1", (Object[])new Object[0]));
        }
        if (this.cBType.slashDamageLevel > 0.0f) {
            String slashValue;
            if (this.cBType.slashDamageLevel % 1.0f == 0.0f) {
                n = Math.round(this.cBType.slashDamageLevel);
                slashValue = String.valueOf(n);
            } else {
                float n2 = this.cBType.slashDamageLevel;
                slashValue = String.valueOf(n2);
            }
            tooltip.add(String.format(" %s %s", slashValue, String.format("%s %s", TextFormatting.BLUE + I18n.func_135052_a((String)"attribute.name.aether.slash", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"attribute.name.aether.damageLevel", (Object[])new Object[0]))));
        }
        if (this.cBType.pierceDamageLevel > 0.0f) {
            String pierceValue;
            if (this.cBType.pierceDamageLevel % 1.0f == 0.0f) {
                n = Math.round(this.cBType.pierceDamageLevel);
                pierceValue = String.valueOf(n);
            } else {
                float n3 = this.cBType.pierceDamageLevel;
                pierceValue = String.valueOf(n3);
            }
            tooltip.add(String.format(" %s %s", pierceValue, String.format("%s %s", TextFormatting.RED + I18n.func_135052_a((String)"attribute.name.aether.pierce", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"attribute.name.aether.damageLevel", (Object[])new Object[0]))));
        }
        if (this.cBType.impactDamageLevel > 0.0f) {
            String impactValue;
            if (this.cBType.impactDamageLevel % 1.0f == 0.0f) {
                n = Math.round(this.cBType.impactDamageLevel);
                impactValue = String.valueOf(n);
            } else {
                float n4 = this.cBType.impactDamageLevel;
                impactValue = String.valueOf(n4);
            }
            tooltip.add(String.format(" %s %s", impactValue, String.format("%s %s", TextFormatting.YELLOW + I18n.func_135052_a((String)"attribute.name.aether.impact", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"attribute.name.aether.damageLevel", (Object[])new Object[0]))));
        }
    }

    public int getItemBurnTime(ItemStack itemStack) {
        if (this.cBType == crossBowTypes.SKYROOT) {
            return 300;
        }
        return 0;
    }

    public crossBowTypes getType() {
        return this.cBType;
    }

    public ItemCrossbow setType(crossBowTypes type) {
        this.cBType = type;
        this.func_77656_e(this.cBType.maxDurability);
        return this;
    }

    public static enum crossBowTypes {
        SKYROOT(0.0f, 4.0f, 0.0f, 4.0f, 82, "skyroot_crossbow"),
        HOLYSTONE(0.0f, 5.0f, 0.0f, 5.0f, 181, "holystone_crossbow"),
        ZANITE(0.0f, 6.0f, 0.0f, 6.0f, 346, "zanite_crossbow"),
        ARKENIUM(0.0f, 8.0f, 0.0f, 8.0f, 4418, "arkenium_crossbow"),
        GRAVETITE(0.0f, 7.0f, 0.0f, 7.0f, 2160, "gravitite_crossbow");

        final float slashDamageLevel;
        final float pierceDamageLevel;
        final float impactDamageLevel;
        final float damage;
        final int maxDurability;
        final String name;

        private crossBowTypes(float slashDamageLevel, float pierceDamageLevel, float impactDamageLevel, float damage, int maxDurability, String name) {
            this.slashDamageLevel = slashDamageLevel;
            this.pierceDamageLevel = pierceDamageLevel;
            this.impactDamageLevel = impactDamageLevel;
            this.damage = damage;
            this.maxDurability = maxDurability;
            this.name = name;
        }
    }
}

