/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.items.weapons;

import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.api.registrar.SoundsAether;
import com.gildedgames.aether.common.entities.projectiles.EntityDart;
import com.gildedgames.aether.common.items.weapons.ItemDartType;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDartShooter
extends Item {
    public ItemDartShooter() {
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (ItemDartType type : ItemDartType.values()) {
            subItems.add((Object)new ItemStack((Item)this, 1, type.ordinal()));
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemDartType dartType = ItemDartType.fromOrdinal(stack.func_77960_j());
        int ammoSlot = this.getMatchingAmmoSlot(player.field_71071_by, dartType.getAmmoItem());
        if (ammoSlot > 0 || player.field_71075_bZ.field_75098_d) {
            player.func_184598_c(hand);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        ItemDartType dartType = ItemDartType.fromOrdinal(stack.func_77960_j());
        int inventorySlot = this.getMatchingAmmoSlot(player.field_71071_by, dartType.getAmmoItem());
        if (inventorySlot < 0 && !player.field_71075_bZ.field_75098_d) {
            return;
        }
        boolean isInfiniteArrow = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"infinity"), (ItemStack)stack) > 0;
        int duration = this.func_77626_a(stack) - timeLeft - 5;
        if (duration > 3) {
            float speed = (float)duration / 15.0f;
            if ((speed = (speed * speed + speed * 2.0f) / 4.0f) > 1.0f) {
                speed = 1.0f;
            }
            EntityDart dart = new EntityDart(world, (EntityLivingBase)player);
            dart.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, speed * 3.0f, 1.0f);
            dart.setDartType(dartType);
            if (speed >= 0.8f) {
                dart.func_70243_d(true);
            }
            if (isInfiniteArrow) {
                dart.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
            }
            player.func_184185_a(SoundsAether.dart_shooter_fire, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + speed * 0.5f);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)dart);
            }
            if (inventorySlot >= 0 && !player.field_71075_bZ.field_75098_d) {
                ItemStack ammoStack = player.field_71071_by.func_70301_a(inventorySlot);
                ammoStack.func_190918_g(1);
                if (ammoStack.func_190916_E() <= 0) {
                    player.field_71071_by.func_184437_d(ammoStack);
                }
            }
        }
    }

    private int getMatchingAmmoSlot(InventoryPlayer inventory, ItemDartType ammo) {
        int searchMeta = ammo.ordinal();
        for (int i = 0; i < inventory.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)inventory.field_70462_a.get(i);
            if (stack.func_77973_b() != ItemsAether.dart || stack.func_77960_j() != searchMeta) continue;
            return i;
        }
        return -1;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + ItemDartType.fromOrdinal(stack.func_77960_j()).getID();
    }
}

