/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.items.weapons;

import com.gildedgames.aether.common.items.IDropOnDeath;
import com.gildedgames.aether.common.items.weapons.ItemDartType;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDart
extends Item
implements IDropOnDeath {
    public static final ItemDartType[] ITEM_VARIANTS = new ItemDartType[]{ItemDartType.GOLDEN, ItemDartType.ENCHANTED, ItemDartType.POISON};

    public ItemDart() {
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (ItemDartType type : ITEM_VARIANTS) {
            subItems.add((Object)new ItemStack((Item)this, 1, type.ordinal()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        ItemDartType type = ITEM_VARIANTS[stack.func_77952_i()];
        int slashDamageLevel = type.getSlashDamageLevel();
        int pierceDamageLevel = type.getPierceDamageLevel();
        int impactDamageLevel = type.getImpactDamageLevel();
        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"item.aether.dart.desc", (Object[])new Object[0]));
        if (slashDamageLevel > 0) {
            this.addDamageLevel("slash", slashDamageLevel, tooltip);
        }
        if (pierceDamageLevel > 0) {
            this.addDamageLevel("pierce", pierceDamageLevel, tooltip);
        }
        if (impactDamageLevel > 0) {
            this.addDamageLevel("impact", impactDamageLevel, tooltip);
        }
    }

    private void addDamageLevel(String damageType, int damageLevel, List<String> tooltip) {
        tooltip.add(TextFormatting.GRAY + String.valueOf(damageLevel) + " " + I18n.func_135052_a((String)("item.aether.bolt." + damageType), (Object[])new Object[0]));
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + ItemDartType.fromOrdinal(stack.func_77960_j()).getID();
    }
}

