/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.items.tools;

import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.init.CreativeTabsAether;
import com.gildedgames.aether.common.items.IDropOnDeath;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemSkyrootBucket
extends ItemBucket
implements IDropOnDeath {
    public ItemSkyrootBucket(Block liquid) {
        super(liquid);
        if (liquid == Blocks.field_150350_a) {
            this.func_77625_d(16);
        }
        this.func_77637_a(CreativeTabsAether.TAB_MISCELLANEOUS);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        BlockPos placePos;
        ItemStack stack = player.func_184586_b(hand);
        boolean isEmpty = stack.func_77973_b() == ItemsAether.skyroot_bucket;
        RayTraceResult traceResult = this.func_77621_a(worldIn, player, isEmpty);
        ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)worldIn, (ItemStack)stack, (RayTraceResult)traceResult);
        if (traceResult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (ret != null) {
            return ret;
        }
        if (traceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        BlockPos pos = traceResult.func_178782_a();
        if (!worldIn.func_175660_a(player, pos)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (isEmpty) {
            if (!player.func_175151_a(pos.func_177972_a(traceResult.field_178784_b), traceResult.field_178784_b, stack)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            IBlockState state = worldIn.func_180495_p(pos);
            if (state.func_185904_a() == Material.field_151586_h && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
                player.func_71029_a(StatList.func_188057_b((Item)this));
                player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)this.fillBucket(stack, player, ItemsAether.skyroot_water_bucket));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        boolean canPlace = worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos);
        BlockPos blockPos = placePos = canPlace && traceResult.field_178784_b == EnumFacing.UP ? pos : pos.func_177972_a(traceResult.field_178784_b);
        if (!player.func_175151_a(placePos, traceResult.field_178784_b, stack)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (this.func_180616_a(player, worldIn, placePos)) {
            player.func_71029_a(StatList.func_188057_b((Item)this));
            return !player.field_71075_bZ.field_75098_d ? new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack(ItemsAether.skyroot_bucket)) : new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    private ItemStack fillBucket(ItemStack emptyBucket, EntityPlayer player, Item fullBucket) {
        if (player.field_71075_bZ.field_75098_d) {
            return emptyBucket;
        }
        emptyBucket.func_190918_g(1);
        if (emptyBucket.func_190926_b()) {
            return new ItemStack(fullBucket);
        }
        if (!player.field_71071_by.func_70441_a(new ItemStack(fullBucket))) {
            player.func_71019_a(new ItemStack(fullBucket), false);
        }
        return emptyBucket;
    }

    public int getItemBurnTime(ItemStack itemStack) {
        if (itemStack.func_77973_b() == ItemsAether.skyroot_bucket) {
            return 200;
        }
        return 0;
    }
}

