/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.items.tools;

import com.gildedgames.aether.api.entity.damage.IDamageLevelsHolder;
import com.gildedgames.aether.common.events.listeners.items.ItemToolListener;
import com.gildedgames.aether.common.init.CreativeTabsAether;
import com.gildedgames.aether.common.init.MaterialsAether;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;

public class ItemAetherAxe
extends ItemAxe
implements IDamageLevelsHolder {
    private float slashDamageLevel = 0.0f;
    private float pierceDamageLevel = 0.0f;
    private float impactDamageLevel = 0.0f;

    public ItemAetherAxe(Item.ToolMaterial material) {
        this(material, 6.0f, -3.2f);
    }

    public ItemAetherAxe(Item.ToolMaterial material, float damageVsEntity, float attackSpeed) {
        super(material, damageVsEntity, attackSpeed);
        this.setHarvestLevel("axe", material.func_77996_d());
        this.func_77637_a(CreativeTabsAether.TAB_TOOLS);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        super.func_77644_a(stack, target, attacker);
        return ItemToolListener.onEntityHit(stack, this.field_77862_b, target, attacker);
    }

    public boolean canMine(IBlockState state) {
        Material material = state.func_185904_a();
        return material == Material.field_151575_d || material == Material.field_151585_k || material == Material.field_151582_l;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        float original = this.field_77862_b.func_77998_b();
        if (this.canMine(state)) {
            return ItemToolListener.getBreakSpeed(stack, state, original);
        }
        return super.func_150893_a(stack, state);
    }

    public int getItemBurnTime(ItemStack itemStack) {
        if (this.field_77862_b == MaterialsAether.SKYROOT_TOOL) {
            return 200;
        }
        return super.getItemBurnTime(itemStack);
    }

    public <T extends ItemAetherAxe> T setSlashDamageLevel(float level) {
        this.slashDamageLevel = level;
        return (T)this;
    }

    public <T extends ItemAetherAxe> T setPierceDamageLevel(float level) {
        this.pierceDamageLevel = level;
        return (T)this;
    }

    public <T extends ItemAetherAxe> T setImpactDamageLevel(float level) {
        this.impactDamageLevel = level;
        return (T)this;
    }

    @Override
    public float getSlashDamageLevel() {
        return this.slashDamageLevel;
    }

    @Override
    public float getPierceDamageLevel() {
        return this.pierceDamageLevel;
    }

    @Override
    public float getImpactDamageLevel() {
        return this.impactDamageLevel;
    }
}

