/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.items.properties;

import com.gildedgames.aether.api.items.properties.IItemProperties;
import com.gildedgames.aether.api.items.properties.ItemPropertiesBuilder;
import com.gildedgames.aether.api.registry.IItemPropertiesRegistry;
import com.gildedgames.aether.common.items.properties.ItemPropertiesImmutable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class ItemPropertiesRegistry
implements IItemPropertiesRegistry {
    private static final IItemProperties DEFAULT = new ItemPropertiesImmutable();
    private final Map<ResourceLocation, IItemProperties> registry = new HashMap<ResourceLocation, IItemProperties>();

    @Override
    @Nonnull
    public IItemProperties getProperties(Item item) {
        return this.registry.getOrDefault(item.getRegistryName(), DEFAULT);
    }

    @Override
    public void registerItem(Item item, ItemPropertiesBuilder def) {
        Validate.isTrue((!this.registry.containsKey(item.getRegistryName()) ? 1 : 0) != 0, (String)"Properties already registered for item %s", (Object[])new Object[]{item.getRegistryName()});
        this.registry.put(item.getRegistryName(), new ItemPropertiesImmutable(def.getSlot(), def.getEffects(), def.getPreconditions(), def.getEffectActivators(), def.getRarity()));
    }
}

