/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.items.other;

import com.gildedgames.aether.common.items.IDropOnDeath;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWrappingPaper
extends Item
implements IDropOnDeath {
    public static PresentDyeData getDyeData(ItemStack stack) {
        return PresentDyeData.readFromNBT(stack.func_77978_p());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        PresentDyeData data = ItemWrappingPaper.getDyeData(stack);
        if (data == null) {
            return;
        }
        tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)data.getBoxColorName(), (Object[])new Object[0]));
        tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)data.getBowColorName(), (Object[])new Object[0]));
        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"item.aether.wrapping_paper.tooltip.craft", (Object[])new Object[0]));
    }

    public static class PresentDyeData {
        public static final String[] dyeNames = new String[]{"black", "red", "green", "brown", "blue", "purple", "cyan", "silver", "gray", "pink", "lime", "yellow", "light_blue", "magenta", "orange", "white"};
        private byte bowColor = 1;
        private byte boxColor = (byte)15;

        public static PresentDyeData readFromNBT(NBTTagCompound compound) {
            PresentDyeData data = new PresentDyeData();
            if (compound == null) {
                return new PresentDyeData();
            }
            data.setBoxColor(compound.func_74771_c("boxColor"));
            data.setBowColor(compound.func_74771_c("bowColor"));
            return data;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound compound) {
            compound.func_74774_a("boxColor", this.getBoxColor());
            compound.func_74774_a("bowColor", this.getBowColor());
            return compound;
        }

        public String getBowColorName() {
            return "item.aether.wrapping_paper.bow." + dyeNames[this.getBowColor()] + ".name";
        }

        public String getBoxColorName() {
            return "item.aether.wrapping_paper.box." + dyeNames[this.getBoxColor()] + ".name";
        }

        public byte getBowColor() {
            return this.bowColor;
        }

        public void setBowColor(byte bowColor) {
            this.bowColor = bowColor;
        }

        public byte getBoxColor() {
            return this.boxColor;
        }

        public void setBoxColor(byte boxColor) {
            this.boxColor = boxColor;
        }
    }
}

