/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.items.other;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.blocks.natural.BlockMoaEgg;
import com.gildedgames.aether.common.entities.animals.EntityMoa;
import com.gildedgames.aether.common.entities.genes.GeneUtil;
import com.gildedgames.aether.common.entities.genes.moa.MoaGenePool;
import com.gildedgames.aether.common.entities.tiles.TileEntityMoaEgg;
import com.gildedgames.aether.common.items.IDropOnDeath;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMoaEgg
extends Item
implements IDropOnDeath {
    private final boolean creativeEgg;

    public ItemMoaEgg(boolean creativeEgg) {
        this.creativeEgg = creativeEgg;
        this.func_77627_a(true);
        this.field_77777_bU = 1;
        this.func_185043_a(new ResourceLocation("curved"), new ModelProperty("curved"));
        this.func_185043_a(new ResourceLocation("flat"), new ModelProperty("flat"));
        this.func_185043_a(new ResourceLocation("pointed"), new ModelProperty("pointed"));
    }

    public static void setGenePool(ItemStack stack, MoaGenePool pool) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound poolTag = new NBTTagCompound();
        pool.write(poolTag);
        stack.func_77978_p().func_74782_a("pool", (NBTBase)poolTag);
    }

    public static MoaGenePool getGenePool(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            ItemMoaEgg.setGenePool(stack, new MoaGenePool());
        }
        NBTTagCompound poolTag = stack.func_77978_p().func_74775_l("pool");
        MoaGenePool pool = new MoaGenePool();
        pool.read(poolTag);
        return pool;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> creativeList, ITooltipFlag flag) {
        MoaGenePool genePool = ItemMoaEgg.getGenePool(stack);
        if (genePool.getFeathers() != null && stack.func_77973_b() != ItemsAether.rainbow_moa_egg) {
            creativeList.add("\u2022 " + I18n.func_135052_a((String)"moa.feathers", (Object[])new Object[]{genePool.getFeathers().gene().localizedName()}));
            creativeList.add("\u2022 " + I18n.func_135052_a((String)"moa.keratin", (Object[])new Object[]{genePool.getKeratin().gene().localizedName()}));
            creativeList.add("\u2022 " + I18n.func_135052_a((String)"moa.eyes", (Object[])new Object[]{genePool.getEyes().gene().localizedName()}));
            creativeList.add("\u2022 " + I18n.func_135052_a((String)"moa.feather_type", (Object[])new Object[]{genePool.getMarks().gene().localizedName()}));
            creativeList.add("");
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int yOffset;
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        boolean replaceable = state.func_177230_c().func_176200_f((IBlockAccess)world, pos);
        int n = yOffset = replaceable ? 0 : 1;
        if (stack.func_190916_E() == 0) {
            return EnumActionResult.FAIL;
        }
        if (!player.func_175151_a(pos, facing, stack)) {
            return EnumActionResult.FAIL;
        }
        if ((world.func_175623_d(pos.func_177982_a(0, yOffset, 0)) || replaceable) && BlocksAether.moa_egg.func_176196_c(world, pos.func_177982_a(0, yOffset, 0))) {
            if (player.field_71075_bZ.field_75098_d || this.creativeEgg) {
                if (!world.field_72995_K) {
                    EntityMoa moa = new EntityMoa(world, GeneUtil.getRandomSeed(world));
                    moa.func_70107_b((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + moa.field_70131_O / 2.0f, (float)pos.func_177952_p() + 0.5f);
                    MoaGenePool stackGenePool = ItemMoaEgg.getGenePool(stack);
                    moa.setRaisedByPlayer(true);
                    world.func_72838_d((Entity)moa);
                    MoaGenePool genePool = (MoaGenePool)moa.getGenePool();
                    if (this.creativeEgg) {
                        genePool.transformFromSeed(GeneUtil.getRandomSeed(world));
                    } else {
                        genePool.transformFromParents(stackGenePool.getStorage().getSeed(), stackGenePool.getStorage().getFatherSeed(), stackGenePool.getStorage().getMotherSeed());
                    }
                }
                stack.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
            if (world.func_72855_b(BlockMoaEgg.BOUNDING_BOX.func_72317_d((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p())) && world.func_175656_a(pos.func_177982_a(0, yOffset, 0), BlocksAether.moa_egg.func_176223_P())) {
                SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), world, pos, (Entity)player);
                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                TileEntityMoaEgg egg = (TileEntityMoaEgg)world.func_175625_s(pos.func_177982_a(0, yOffset, 0));
                if (egg != null) {
                    MoaGenePool stackGenes = ItemMoaEgg.getGenePool(stack);
                    MoaGenePool teGenes = egg.getGenePool();
                    teGenes.transformFromParents(stackGenes.getStorage().getSeed(), stackGenes.getStorage().getFatherSeed(), stackGenes.getStorage().getMotherSeed());
                    egg.setPlayerPlaced();
                }
                stack.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    private boolean checkCollision(BlockPos pos, World world, float yOffset) {
        return false;
    }

    public String func_77653_i(ItemStack stack) {
        return this.creativeEgg ? super.func_77653_i(stack) : super.func_77653_i(stack);
    }

    public boolean func_77651_p() {
        return true;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    private static class ModelProperty
    implements IItemPropertyGetter {
        private final String propertyName;

        public ModelProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        @SideOnly(value=Side.CLIENT)
        public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
            String mark;
            MoaGenePool genePool = ItemMoaEgg.getGenePool(stack);
            if (genePool.getMarks() != null && (mark = genePool.getMarks().gene().getResourceName()).equals(this.propertyName)) {
                return 1.0f;
            }
            return 0.0f;
        }
    }
}

