/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.items.consumables;

import com.gildedgames.aether.api.entity.effects.IAetherStatusEffectPool;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffects;
import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.items.ItemDropOnDeath;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTea
extends ItemDropOnDeath {
    private IAetherStatusEffects.effectTypes effect;
    private boolean hasExtraInfo;

    public ItemTea(IAetherStatusEffects.effectTypes effect, boolean hasExtraInfo) {
        this.effect = effect;
        this.hasExtraInfo = hasExtraInfo;
        this.field_77777_bU = 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String time = ItemTea.getEffectTimeInfo(this.effect.activeEffectTime);
        tooltip.add(String.format("%s (%s)", TextFormatting.BLUE + I18n.func_135052_a((String)this.effect.name, (Object[])new Object[0]), TextFormatting.BLUE + time));
        if (this.hasExtraInfo) {
            tooltip.add("");
            tooltip.add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"item.aether.tea.applied.desc", (Object[])new Object[0]));
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)(this.func_77658_a() + ".desc"), (Object[])new Object[0]));
        }
    }

    private static String getEffectTimeInfo(int time) {
        int i = time;
        int j = time / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        EntityPlayer entityPlayer;
        EntityPlayer entityPlayer2 = entityPlayer = entityLiving instanceof EntityPlayer ? (EntityPlayer)entityLiving : null;
        if (entityPlayer instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)entityPlayer, stack);
        }
        if (entityPlayer != null) {
            entityPlayer.func_71029_a(Objects.requireNonNull(StatList.func_188057_b((Item)this)));
        }
        if (entityPlayer == null || !entityPlayer.field_71075_bZ.field_75098_d) {
            IAetherStatusEffectPool statusEffectPool;
            stack.func_190918_g(1);
            IAetherStatusEffectPool iAetherStatusEffectPool = statusEffectPool = entityPlayer != null ? (IAetherStatusEffectPool)entityPlayer.getCapability(CapabilitiesAether.STATUS_EFFECT_POOL, null) : (IAetherStatusEffectPool)entityLiving.getCapability(CapabilitiesAether.STATUS_EFFECT_POOL, null);
            if (statusEffectPool != null) {
                statusEffectPool.applyStatusEffect(this.effect, 100);
            }
            if (stack.func_190926_b()) {
                return new ItemStack(ItemsAether.scatterglass_vial);
            }
            if (entityPlayer != null) {
                entityPlayer.field_71071_by.func_70441_a(new ItemStack(ItemsAether.scatterglass_vial));
            }
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }
}

