/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.items.consumables;

import com.gildedgames.aether.api.entity.effects.IAetherStatusEffectPool;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffects;
import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.items.IDropOnDeath;
import com.gildedgames.aether.common.items.IUsesCustomSound;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class ItemHealingStone
extends Item
implements IDropOnDeath,
IUsesCustomSound {
    public static final int MAX_USES = 5;

    public ItemHealingStone() {
        this.func_185043_a(new ResourceLocation("uses"), (stack, world, entity) -> {
            if (!stack.func_190926_b()) {
                return (float)ItemHealingStone.getUsesLeft(stack) * 0.2f;
            }
            return 1.0f;
        });
    }

    private static void initTagCompound(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("usesLeft", 5);
        stack.func_77982_d(tag);
    }

    public static int getUsesLeft(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        if (stack.func_77978_p() == null) {
            ItemHealingStone.initTagCompound(stack);
        }
        return stack.func_77978_p().func_74762_e("usesLeft");
    }

    public static void setUsesLeft(ItemStack stack, int usesLeft) {
        if (stack == null) {
            return;
        }
        if (stack.func_77978_p() == null) {
            ItemHealingStone.initTagCompound(stack);
        }
        stack.func_77978_p().func_74768_a("usesLeft", usesLeft);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IAetherStatusEffectPool statusEffectPool = (IAetherStatusEffectPool)player.getCapability(CapabilitiesAether.STATUS_EFFECT_POOL, null);
        if (statusEffectPool != null && !statusEffectPool.isEffectApplied(IAetherStatusEffects.effectTypes.AMBROSIUM_POISONING) && ItemHealingStone.getUsesLeft(stack) > 0 && player.func_110139_bj() < 20.0f) {
            player.func_184598_c(EnumHand.MAIN_HAND);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entity) {
        ItemHealingStone.setUsesLeft(stack, ItemHealingStone.getUsesLeft(stack) - 1);
        if (!worldIn.field_72995_K) {
            IAetherStatusEffectPool statusEffectPool = (IAetherStatusEffectPool)entity.getCapability(CapabilitiesAether.STATUS_EFFECT_POOL, null);
            if (statusEffectPool != null) {
                if (!statusEffectPool.isEffectApplied(IAetherStatusEffects.effectTypes.AMBROSIUM_POISONING)) {
                    statusEffectPool.applyStatusEffect(IAetherStatusEffects.effectTypes.AMBROSIUM_POISONING, 25);
                } else {
                    statusEffectPool.modifyActiveEffectBuildup(IAetherStatusEffects.effectTypes.AMBROSIUM_POISONING, statusEffectPool.getBuildupFromEffect(IAetherStatusEffects.effectTypes.AMBROSIUM_POISONING) + 25);
                }
            }
            if (entity.func_110143_aJ() < entity.func_110138_aP()) {
                float dif = entity.func_110138_aP() - entity.func_110143_aJ();
                float leftOver = 4.0f - dif;
                if (dif > 4.0f) {
                    entity.func_70691_i(4.0f);
                } else if (leftOver > 0.0f) {
                    entity.func_70691_i(dif);
                    entity.func_110149_m(Math.min(20.0f, entity.func_110139_bj() + leftOver));
                }
            } else {
                entity.func_110149_m(Math.min(20.0f, entity.func_110139_bj() + 4.0f));
            }
        }
        if (ItemHealingStone.getUsesLeft(stack) <= 0) {
            stack = new ItemStack(ItemsAether.healing_stone_depleted);
        }
        return stack;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public boolean func_77651_p() {
        return true;
    }

    @Override
    public boolean usesCustomSound(ItemStack stack) {
        return true;
    }

    @Override
    public SoundEvent getDefaultSound() {
        return SoundEvents.field_187664_bz;
    }

    @Override
    public SoundEvent getCustomSound() {
        return null;
    }
}

