/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.items.companions;

import com.gildedgames.aether.common.items.companions.ItemCompanion;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDeathSeal
extends ItemCompanion {
    public static void setDisabledTimer(ItemStack stack, World world, int timer) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        compound.func_74772_a("disabledTimer", world.func_82737_E() + (long)timer);
        stack.func_77964_b(1);
    }

    public static long getTicksUntilEnabled(ItemStack stack, World world) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null || !compound.func_74764_b("disabledTimer")) {
            return 0L;
        }
        return compound.func_74763_f("disabledTimer") - world.func_82737_E();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        long disabledTime = ItemDeathSeal.getTicksUntilEnabled(stack, worldIn);
        if (disabledTime <= 0L) {
            stack.func_77964_b(0);
        } else {
            stack.func_77964_b(1);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        long disabledTime = ItemDeathSeal.getTicksUntilEnabled(stack, worldIn);
        if (disabledTime > 0L) {
            tooltip.add(TextFormatting.RED + "" + TextFormatting.ITALIC + "Disabled! Ready in " + this.parseTicks(disabledTime));
        }
    }
}

