/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.items.companions;

import com.gildedgames.aether.common.items.InformationProvider;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCompanion
extends Item {
    private final DecimalFormat timeFormat = new DecimalFormat("0.0");
    private InformationProvider informationProvider;

    public ItemCompanion() {
        this.func_77625_d(1);
    }

    public ItemCompanion(InformationProvider informationProvider) {
        this();
        this.informationProvider = informationProvider;
    }

    public static void setRespawnTimer(ItemStack stack, World world, int timer) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        compound.func_74772_a("respawnTimer", world.func_82737_E() + (long)timer);
    }

    public static long getTicksUntilRespawn(ItemStack stack, World world) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null || !compound.func_74764_b("respawnTimer")) {
            return 0L;
        }
        return compound.func_74763_f("respawnTimer") - world.func_82737_E();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        long respawn = ItemCompanion.getTicksUntilRespawn(stack, worldIn);
        if (respawn > 0L) {
            tooltip.add(TextFormatting.RED + "" + TextFormatting.ITALIC + "Disabled! Respawns in " + this.parseTicks(respawn) + ".");
        }
        if (this.informationProvider != null) {
            this.informationProvider.addInformation(stack, tooltip, flagIn);
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    protected String parseTicks(long ticks) {
        boolean useMinutes = ticks > 1200L;
        return this.timeFormat.format((float)ticks / (useMinutes ? 1200.0f : 20.0f)) + " " + (useMinutes ? "minutes" : "seconds");
    }
}

