/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.items.blocks;

import com.gildedgames.aether.common.items.other.ItemWrappingPaper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockPresent
extends ItemBlock {
    public ItemBlockPresent(Block block) {
        super(block);
        this.func_77625_d(1);
    }

    public static PresentData getData(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            return PresentData.readFromNBT(stack.func_77978_p());
        }
        return new PresentData();
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        PresentData data = ItemBlockPresent.getData(stack);
        if (data.getStack() != null) {
            tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"item.aether.present.tooltip.hasitem", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"item.aether.present.tooltip.empty", (Object[])new Object[0]));
        }
    }

    public static class PresentData {
        private ItemStack stack;
        private ItemWrappingPaper.PresentDyeData dye = new ItemWrappingPaper.PresentDyeData();

        public static PresentData readFromNBT(NBTTagCompound compound) {
            PresentData data = new PresentData();
            if (compound.func_74764_b("item")) {
                data.stack = new ItemStack(compound.func_74775_l("item"));
            }
            if (compound.func_74764_b("dye")) {
                data.dye = ItemWrappingPaper.PresentDyeData.readFromNBT(compound.func_74775_l("dye"));
            }
            return data;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound compound) {
            if (this.stack != null) {
                compound.func_74782_a("item", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
            }
            if (this.dye != null) {
                compound.func_74782_a("dye", (NBTBase)this.dye.writeToNBT(new NBTTagCompound()));
            }
            return compound;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
        }

        public ItemWrappingPaper.PresentDyeData getDye() {
            return this.dye;
        }

        public void setDye(ItemWrappingPaper.PresentDyeData data) {
            this.dye = data;
        }
    }
}

