/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.items.armor;

import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerPatronRewardModule;
import com.gildedgames.aether.common.init.CreativeTabsAether;
import com.gildedgames.aether.common.patron.armor.PatronRewardArmor;
import com.gildedgames.aether.common.util.helpers.EntityUtil;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAetherGloves
extends Item {
    public final GloveType gloveType;

    public ItemAetherGloves(GloveType type) {
        this.gloveType = type;
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabsAether.TAB_ARMOR);
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getGloveTexture(EntityPlayer player) {
        String skinType = EntityUtil.getSkin(player);
        boolean slim = skinType.equals("slim");
        PlayerAether playerAether = PlayerAether.getPlayer(player);
        PatronRewardArmor armorChoice = playerAether.getModule(PlayerPatronRewardModule.class).getChoices().getArmorChoice();
        if (armorChoice != null) {
            return armorChoice.getArmorGloveTexture(slim);
        }
        return slim ? this.gloveType.getTextureSlim() : this.gloveType.getTexture();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        int n;
        tooltip.add("");
        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"item.aether.tooltip.modifiers.gloves", (Object[])new Object[0]));
        if (this.getAttackSpeed() > 0.0) {
            tooltip.add(TextFormatting.GRAY + " " + new DecimalFormat("#.#").format(0.2 + this.getAttackSpeed()) + " " + I18n.func_135052_a((String)"attribute.name.generic.attackSpeed", (Object[])new Object[0]));
        }
        if (this.getSlashDamageLevel() > 0.0f) {
            String slashValue;
            if (this.getSlashDamageLevel() % 1.0f == 0.0f) {
                n = Math.round(this.getSlashDamageLevel());
                slashValue = String.valueOf(n);
            } else {
                float n2 = this.getSlashDamageLevel();
                slashValue = String.valueOf(n2);
            }
            tooltip.add(String.format(" %s %s", slashValue, String.format("%s %s", TextFormatting.BLUE + I18n.func_135052_a((String)"attribute.name.aether.slash", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"attribute.name.aether.damageLevel", (Object[])new Object[0]))));
        }
        if (this.getPierceDamageLevel() > 0.0f) {
            String pierceValue;
            if (this.getPierceDamageLevel() % 1.0f == 0.0f) {
                n = Math.round(this.getPierceDamageLevel());
                pierceValue = String.valueOf(n);
            } else {
                float n3 = this.getPierceDamageLevel();
                pierceValue = String.valueOf(n3);
            }
            tooltip.add(String.format(" %s %s", pierceValue, String.format("%s %s", TextFormatting.RED + I18n.func_135052_a((String)"attribute.name.aether.pierce", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"attribute.name.aether.damageLevel", (Object[])new Object[0]))));
        }
        if (this.getImpactDamageLevel() > 0.0f) {
            String impactValue;
            if (this.getImpactDamageLevel() % 1.0f == 0.0f) {
                n = Math.round(this.getImpactDamageLevel());
                impactValue = String.valueOf(n);
            } else {
                float n4 = this.getImpactDamageLevel();
                impactValue = String.valueOf(n4);
            }
            tooltip.add(String.format(" %s %s", impactValue, String.format("%s %s", TextFormatting.YELLOW + I18n.func_135052_a((String)"attribute.name.aether.impact", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"attribute.name.aether.damageLevel", (Object[])new Object[0]))));
        }
    }

    public SoundEvent getGloveSound() {
        return this.gloveType.getEquipSound();
    }

    public float getSlashDamageLevel() {
        return this.gloveType.getSlashDamageLevel();
    }

    public float getPierceDamageLevel() {
        return this.gloveType.getPierceDamageLevel();
    }

    public float getImpactDamageLevel() {
        return this.gloveType.getImpactDamageLevel();
    }

    public double getAttackSpeed() {
        return this.gloveType.getAttackSpeed();
    }

    public static enum GloveType {
        TAEGOREHIDE("taegore_hide_gloves", SoundEvents.field_187728_s, 0.0f, 0.0f, 4.0f, 1.4),
        BURRUKAIPELT("burrukai_pelt_gloves", SoundEvents.field_187728_s, 0.0f, 0.0f, 5.0f, 1.4),
        ZANITE("zanite_gloves", SoundEvents.field_187725_r, 0.0f, 0.0f, 6.0f, 1.4),
        ARKENIUM("arkenium_gloves", SoundEvents.field_187725_r, 0.0f, 0.0f, 8.0f, 0.8),
        GRAVITITE("gravitite_gloves", SoundEvents.field_187716_o, 0.0f, 0.0f, 7.0f, 1.4),
        VALKYRIE("valkyrie_gloves", SoundEvents.field_187716_o, 0.0f, 0.0f, 0.0f, 1.4),
        NEPTUNE("neptune_gloves", SoundEvents.field_187716_o, 0.0f, 0.0f, 0.0f, 1.4),
        PHOENIX("phoenix_gloves", SoundEvents.field_187716_o, 0.0f, 0.0f, 0.0f, 1.4),
        OBSIDIAN("obsidian_gloves", SoundEvents.field_187716_o, 0.0f, 0.0f, 0.0f, 1.4);

        private final ResourceLocation texture;
        private final ResourceLocation textureSlim;
        private final SoundEvent equipSound;
        private final float slashDamageLevel;
        private final float pierceDamageLevel;
        private final float impactDamageLevel;
        private final double attackSpeed;

        private GloveType(String texture, SoundEvent equipSound, float slashDamageLevel, float pierceDamageLevel, float impactDamageLevel, double attackSpeed) {
            this.texture = AetherCore.getResource("textures/armor/" + texture + ".png");
            this.textureSlim = AetherCore.getResource("textures/armor/" + texture + "_slim.png");
            this.equipSound = equipSound;
            this.slashDamageLevel = slashDamageLevel;
            this.pierceDamageLevel = pierceDamageLevel;
            this.impactDamageLevel = impactDamageLevel;
            this.attackSpeed = attackSpeed;
        }

        public ResourceLocation getTextureSlim() {
            return this.textureSlim;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public SoundEvent getEquipSound() {
            return this.equipSound;
        }

        public float getSlashDamageLevel() {
            return this.slashDamageLevel;
        }

        public float getPierceDamageLevel() {
            return this.pierceDamageLevel;
        }

        public float getImpactDamageLevel() {
            return this.impactDamageLevel;
        }

        public double getAttackSpeed() {
            return this.attackSpeed;
        }
    }
}

