/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.init;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.blocks.decorative.BlockAgiositeDecorative;
import com.gildedgames.aether.common.blocks.decorative.BlockFadedHolystoneDecorative;
import com.gildedgames.aether.common.blocks.decorative.BlockHellfirestoneDecorative;
import com.gildedgames.aether.common.blocks.decorative.BlockHolystoneDecorative;
import com.gildedgames.aether.common.blocks.decorative.BlockIcestoneBricksDecorative;
import com.gildedgames.aether.common.blocks.decorative.BlockQuicksoilGlassDecorative;
import com.gildedgames.aether.common.blocks.decorative.BlockQuicksoilGlassPaneDecorative;
import com.gildedgames.aether.common.blocks.decorative.BlockRockGlassDecorative;
import com.gildedgames.aether.common.blocks.decorative.BlockRockGlassPaneDecorative;
import com.gildedgames.aether.common.blocks.decorative.BlockSentrystoneDecorative;
import com.gildedgames.aether.common.blocks.decorative.BlockSentrystoneDecorativeLit;
import com.gildedgames.aether.common.blocks.decorative.BlockSkyrootDecorative;
import com.gildedgames.aether.common.blocks.decorative.BlockTherastoneDecorative;
import com.gildedgames.aether.common.blocks.decorative.BlockTherawoodDecorative;
import com.gildedgames.aether.common.blocks.properties.BlockVariant;
import com.gildedgames.aether.common.recipes.CoolerRecipes;
import com.gildedgames.aether.common.recipes.MasonryRecipes;
import com.gildedgames.aether.common.recipes.RecipePresentCrafting;
import com.gildedgames.aether.common.recipes.RecipeWrappingPaper;
import com.gildedgames.aether.common.recipes.altar.AltarEnchantRecipe;
import com.gildedgames.aether.common.recipes.altar.AltarRepairRecipe;
import com.gildedgames.aether.common.recipes.simple.SimpleRecipe;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber
public class RecipesAether {
    public static void init() {
        RecipesAether.registerOreDictionary();
        RecipesAether.registerFurnaceRecipes();
        RecipesAether.registerAltarRecipes();
        RecipesAether.registerMasonryRecipes();
        RecipesAether.registerCoolerRecipes();
    }

    private static void registerFurnaceRecipes() {
        RecipesAether.registerSmeltingRecipe(new ItemStack(BlocksAether.holystone), new ItemStack(BlocksAether.agiosite), 0.1f);
        RecipesAether.registerSmeltingRecipe(new ItemStack(BlocksAether.arkenium_ore), new ItemStack(ItemsAether.arkenium), 0.85f);
        RecipesAether.registerSmeltingRecipe(new ItemStack(BlocksAether.gravitite_ore), new ItemStack(ItemsAether.gravitite_plate), 1.0f);
        RecipesAether.registerSmeltingRecipe(new ItemStack(BlocksAether.quicksoil), new ItemStack(BlocksAether.quicksoil_glass), 0.1f);
        RecipesAether.registerSmeltingRecipe(new ItemStack(ItemsAether.moa_egg_item), new ItemStack(ItemsAether.fried_moa_egg), 0.4f);
        RecipesAether.registerSmeltingRecipe(new ItemStack(ItemsAether.rainbow_moa_egg), new ItemStack(ItemsAether.fried_moa_egg), 0.4f);
        RecipesAether.registerSmeltingRecipe(new ItemStack(BlocksAether.crude_scatterglass), new ItemStack(BlocksAether.scatterglass), 0.1f);
        RecipesAether.registerSmeltingRecipe(new ItemStack(ItemsAether.raw_taegore_meat), new ItemStack(ItemsAether.taegore_steak), 0.4f);
        RecipesAether.registerSmeltingRecipe(new ItemStack(ItemsAether.burrukai_rib_cut), new ItemStack(ItemsAether.burrukai_ribs), 0.4f);
        RecipesAether.registerSmeltingRecipe(new ItemStack(ItemsAether.kirrid_loin), new ItemStack(ItemsAether.kirrid_cutlet), 0.4f);
        RecipesAether.registerSmeltingRecipe(new ItemStack(ItemsAether.skyroot_lizard_stick), new ItemStack(ItemsAether.skyroot_lizard_stick_roasted), 0.65f);
    }

    public static void registerOreDictionary() {
        OreDictionary.registerOre((String)"skyrootplanks", (Block)BlocksAether.skyroot_planks);
        OreDictionary.registerOre((String)"skyrootplanks", (Block)BlocksAether.dark_skyroot_planks);
        OreDictionary.registerOre((String)"skyrootplanks", (Block)BlocksAether.light_skyroot_planks);
        OreDictionary.registerOre((String)"feather", (Item)ItemsAether.moa_feather);
        OreDictionary.registerOre((String)"feather", (Item)ItemsAether.cockatrice_feather);
        OreDictionary.registerOre((String)"aerleather", (Item)ItemsAether.taegore_hide);
        OreDictionary.registerOre((String)"aerleather", (Item)ItemsAether.burrukai_pelt);
        OreDictionary.registerOre((String)"sugar", (Item)ItemsAether.swet_sugar);
        OreDictionary.registerOre((String)"holystone", (ItemStack)new ItemStack(BlocksAether.holystone, 1, 0));
        OreDictionary.registerOre((String)"holystone", (ItemStack)new ItemStack(BlocksAether.holystone, 1, 1));
        for (BlockVariant variant : BlockSkyrootDecorative.PROPERTY_VARIANT.func_177700_c()) {
            OreDictionary.registerOre((String)"skyroot_decorative", (ItemStack)new ItemStack(BlocksAether.skyroot_decorative, 1, variant.getMeta()));
        }
        OreDictionary.registerOre((String)"skyroot_decorative", (ItemStack)new ItemStack(BlocksAether.skyroot_beam, 1));
        for (BlockVariant variant : BlockSkyrootDecorative.PROPERTY_VARIANT.func_177700_c()) {
            OreDictionary.registerOre((String)"wisproot_decorative", (ItemStack)new ItemStack(BlocksAether.light_skyroot_decorative, 1, variant.getMeta()));
        }
        OreDictionary.registerOre((String)"wisproot_decorative", (ItemStack)new ItemStack(BlocksAether.light_skyroot_beam, 1));
        for (BlockVariant variant : BlockSkyrootDecorative.PROPERTY_VARIANT.func_177700_c()) {
            OreDictionary.registerOre((String)"greatroot_decorative", (ItemStack)new ItemStack(BlocksAether.dark_skyroot_decorative, 1, variant.getMeta()));
        }
        OreDictionary.registerOre((String)"greatroot_decorative", (ItemStack)new ItemStack(BlocksAether.dark_skyroot_beam, 1));
        for (BlockVariant variant : BlockSkyrootDecorative.PROPERTY_VARIANT.func_177700_c()) {
            OreDictionary.registerOre((String)"therawood_decorative", (ItemStack)new ItemStack(BlocksAether.therawood_decorative, 1, variant.getMeta()));
        }
        OreDictionary.registerOre((String)"therawood_decorative", (ItemStack)new ItemStack(BlocksAether.therawood_beam, 1));
        for (BlockVariant variant : BlockIcestoneBricksDecorative.PROPERTY_VARIANT.func_177700_c()) {
            OreDictionary.registerOre((String)"icestone_bricks_decorative", (ItemStack)new ItemStack(BlocksAether.icestone_bricks_decorative, 1, variant.getMeta()));
        }
        OreDictionary.registerOre((String)"icestone_bricks_decorative", (ItemStack)new ItemStack(BlocksAether.icestone_pillar, 1));
        for (BlockVariant variant : BlockHolystoneDecorative.PROPERTY_VARIANT.func_177700_c()) {
            OreDictionary.registerOre((String)"holystone_brick_decorative", (ItemStack)new ItemStack(BlocksAether.holystone_brick_decorative, 1, variant.getMeta()));
        }
        OreDictionary.registerOre((String)"holystone_brick_decorative", (ItemStack)new ItemStack(BlocksAether.holystone_pillar, 1));
        for (BlockVariant variant : BlockFadedHolystoneDecorative.PROPERTY_VARIANT.func_177700_c()) {
            OreDictionary.registerOre((String)"faded_holystone_brick_decorative", (ItemStack)new ItemStack(BlocksAether.faded_holystone_brick_decorative, 1, variant.getMeta()));
        }
        OreDictionary.registerOre((String)"faded_holystone_brick_decorative", (ItemStack)new ItemStack(BlocksAether.faded_holystone_pillar, 1));
        OreDictionary.registerOre((String)"faded_holystone_brick", (ItemStack)new ItemStack(BlocksAether.faded_holystone_brick, 1));
        for (BlockVariant variant : BlockIcestoneBricksDecorative.PROPERTY_VARIANT.func_177700_c()) {
            OreDictionary.registerOre((String)"agiosite_brick_decorative", (ItemStack)new ItemStack(BlocksAether.agiosite_brick_decorative, 1, variant.getMeta()));
        }
        OreDictionary.registerOre((String)"agiosite_brick_decorative", (ItemStack)new ItemStack(BlocksAether.agiosite_pillar, 1));
        for (BlockVariant variant : BlockIcestoneBricksDecorative.PROPERTY_VARIANT.func_177700_c()) {
            OreDictionary.registerOre((String)"sentrystone_brick_decorative", (ItemStack)new ItemStack(BlocksAether.sentrystone_brick_decorative, 1, variant.getMeta()));
        }
        OreDictionary.registerOre((String)"sentrystone_brick_decorative", (ItemStack)new ItemStack(BlocksAether.sentrystone_pillar, 1));
        for (BlockVariant variant : BlockIcestoneBricksDecorative.PROPERTY_VARIANT.func_177700_c()) {
            OreDictionary.registerOre((String)"sentrystone_brick_decorative", (ItemStack)new ItemStack(BlocksAether.sentrystone_brick_decorative_lit, 1, variant.getMeta()));
        }
        OreDictionary.registerOre((String)"sentrystone_brick_decorative", (ItemStack)new ItemStack(BlocksAether.sentrystone_pillar_lit, 1));
        for (BlockVariant variant : BlockIcestoneBricksDecorative.PROPERTY_VARIANT.func_177700_c()) {
            OreDictionary.registerOre((String)"hellfirestone_brick_decorative", (ItemStack)new ItemStack(BlocksAether.hellfirestone_brick_decorative, 1, variant.getMeta()));
        }
        OreDictionary.registerOre((String)"hellfirestone_brick_decorative", (ItemStack)new ItemStack(BlocksAether.hellfirestone_pillar, 1));
        OreDictionary.registerOre((String)"hellfirestone_brick_decorative", (ItemStack)new ItemStack(BlocksAether.hellfirestone_lantern, 1));
    }

    @SubscribeEvent
    public static void registerCraftingRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry r = event.getRegistry();
        r.register(new RecipeWrappingPaper().setRegistryName(AetherCore.getResource("wrapping_paper")));
        r.register(new RecipePresentCrafting().setRegistryName(AetherCore.getResource("present_crafting")));
    }

    private static void registerAltarRecipes() {
        AetherAPI.content().altar().registerAltarRecipe(new AltarEnchantRecipe(2, new ItemStack(ItemsAether.blueberries), new ItemStack(ItemsAether.enchanted_blueberry)));
        AetherAPI.content().altar().registerAltarRecipe(new AltarEnchantRecipe(4, new ItemStack(ItemsAether.wyndberry), new ItemStack(ItemsAether.enchanted_wyndberry)));
        AetherAPI.content().altar().registerAltarRecipe(new AltarRepairRecipe());
        AetherAPI.content().altar().registerAltarRecipe(new AltarEnchantRecipe(5, new ItemStack(ItemsAether.healing_stone_depleted), new ItemStack(ItemsAether.healing_stone)));
    }

    private static void registerMasonryRecipes() {
        MasonryRecipes.instance().addMasonry(BlocksAether.holystone_brick, new ItemStack(BlocksAether.holystone_brick_decorative, 1, BlockHolystoneDecorative.BASE_BRICKS.getMeta()), new ItemStack(BlocksAether.holystone_brick_decorative, 1, BlockHolystoneDecorative.BASE_PILLAR.getMeta()), new ItemStack(BlocksAether.holystone_brick_decorative, 1, BlockHolystoneDecorative.CAPSTONE_BRICKS.getMeta()), new ItemStack(BlocksAether.holystone_brick_decorative, 1, BlockHolystoneDecorative.CAPSTONE_PILLAR.getMeta()), new ItemStack(BlocksAether.holystone_brick_decorative, 1, BlockHolystoneDecorative.FLAGSTONES.getMeta()), new ItemStack(BlocksAether.holystone_brick_decorative, 1, BlockHolystoneDecorative.HEADSTONE.getMeta()), new ItemStack(BlocksAether.holystone_brick_decorative, 1, BlockHolystoneDecorative.KEYSTONE.getMeta()), new ItemStack(BlocksAether.holystone_pillar, 1), new ItemStack(BlocksAether.faded_holystone_brick, 1));
        MasonryRecipes.instance().addMasonry(BlocksAether.sentrystone_brick, new ItemStack(BlocksAether.sentrystone_brick_decorative, 1, BlockSentrystoneDecorative.BASE_BRICKS.getMeta()), new ItemStack(BlocksAether.sentrystone_brick_decorative, 1, BlockSentrystoneDecorative.BASE_PILLAR.getMeta()), new ItemStack(BlocksAether.sentrystone_brick_decorative, 1, BlockSentrystoneDecorative.CAPSTONE_BRICKS.getMeta()), new ItemStack(BlocksAether.sentrystone_brick_decorative, 1, BlockSentrystoneDecorative.CAPSTONE_PILLAR.getMeta()), new ItemStack(BlocksAether.sentrystone_brick_decorative, 1, BlockSentrystoneDecorative.FLAGSTONES.getMeta()), new ItemStack(BlocksAether.sentrystone_brick_decorative, 1, BlockSentrystoneDecorative.LIGHTSTONE.getMeta()), new ItemStack(BlocksAether.sentrystone_brick_decorative, 1, BlockSentrystoneDecorative.KEYSTONE.getMeta()), new ItemStack(BlocksAether.sentrystone_pillar, 1), new ItemStack(BlocksAether.sentrystone_brick_decorative_lit, 1, BlockSentrystoneDecorativeLit.BASE_BRICKS.getMeta()), new ItemStack(BlocksAether.sentrystone_brick_decorative_lit, 1, BlockSentrystoneDecorativeLit.BASE_PILLAR.getMeta()), new ItemStack(BlocksAether.sentrystone_brick_decorative_lit, 1, BlockSentrystoneDecorativeLit.CAPSTONE_BRICKS.getMeta()), new ItemStack(BlocksAether.sentrystone_brick_decorative_lit, 1, BlockSentrystoneDecorativeLit.CAPSTONE_PILLAR.getMeta()), new ItemStack(BlocksAether.sentrystone_brick_decorative_lit, 1, BlockSentrystoneDecorativeLit.LIGHTSTONE.getMeta()), new ItemStack(BlocksAether.sentrystone_brick_decorative_lit, 1, BlockSentrystoneDecorativeLit.KEYSTONE.getMeta()), new ItemStack(BlocksAether.sentrystone_pillar_lit, 1));
        MasonryRecipes.instance().addMasonry(BlocksAether.hellfirestone_brick, new ItemStack(BlocksAether.hellfirestone_brick_decorative, 1, BlockHellfirestoneDecorative.BASE_BRICKS.getMeta()), new ItemStack(BlocksAether.hellfirestone_brick_decorative, 1, BlockHellfirestoneDecorative.BASE_PILLAR.getMeta()), new ItemStack(BlocksAether.hellfirestone_brick_decorative, 1, BlockHellfirestoneDecorative.CAPSTONE_BRICKS.getMeta()), new ItemStack(BlocksAether.hellfirestone_brick_decorative, 1, BlockHellfirestoneDecorative.CAPSTONE_PILLAR.getMeta()), new ItemStack(BlocksAether.hellfirestone_brick_decorative, 1, BlockHellfirestoneDecorative.FLAGSTONES.getMeta()), new ItemStack(BlocksAether.hellfirestone_lantern, 1, 0), new ItemStack(BlocksAether.hellfirestone_brick_decorative, 1, BlockHellfirestoneDecorative.KEYSTONE.getMeta()), new ItemStack(BlocksAether.hellfirestone_pillar, 1));
        MasonryRecipes.instance().addMasonry(BlocksAether.faded_holystone_brick, new ItemStack(BlocksAether.faded_holystone_brick_decorative, 1, BlockFadedHolystoneDecorative.BASE_BRICKS.getMeta()), new ItemStack(BlocksAether.faded_holystone_brick_decorative, 1, BlockFadedHolystoneDecorative.BASE_PILLAR.getMeta()), new ItemStack(BlocksAether.faded_holystone_brick_decorative, 1, BlockFadedHolystoneDecorative.CAPSTONE_BRICKS.getMeta()), new ItemStack(BlocksAether.faded_holystone_brick_decorative, 1, BlockFadedHolystoneDecorative.CAPSTONE_PILLAR.getMeta()), new ItemStack(BlocksAether.faded_holystone_brick_decorative, 1, BlockFadedHolystoneDecorative.FLAGSTONES.getMeta()), new ItemStack(BlocksAether.faded_holystone_brick_decorative, 1, BlockFadedHolystoneDecorative.HEADSTONE.getMeta()), new ItemStack(BlocksAether.faded_holystone_brick_decorative, 1, BlockFadedHolystoneDecorative.KEYSTONE.getMeta()), new ItemStack(BlocksAether.faded_holystone_pillar, 1));
        MasonryRecipes.instance().addMasonry(BlocksAether.agiosite_brick, new ItemStack(BlocksAether.agiosite_brick_decorative, 1, BlockAgiositeDecorative.BASE_BRICKS.getMeta()), new ItemStack(BlocksAether.agiosite_brick_decorative, 1, BlockAgiositeDecorative.BASE_PILLAR.getMeta()), new ItemStack(BlocksAether.agiosite_brick_decorative, 1, BlockAgiositeDecorative.CAPSTONE_BRICKS.getMeta()), new ItemStack(BlocksAether.agiosite_brick_decorative, 1, BlockAgiositeDecorative.CAPSTONE_PILLAR.getMeta()), new ItemStack(BlocksAether.agiosite_brick_decorative, 1, BlockAgiositeDecorative.FLAGSTONES.getMeta()), new ItemStack(BlocksAether.agiosite_brick_decorative, 1, BlockAgiositeDecorative.KEYSTONE.getMeta()), new ItemStack(BlocksAether.agiosite_pillar, 1));
        MasonryRecipes.instance().addMasonry(BlocksAether.icestone_bricks, new ItemStack(BlocksAether.icestone_bricks_decorative, 1, BlockAgiositeDecorative.BASE_BRICKS.getMeta()), new ItemStack(BlocksAether.icestone_bricks_decorative, 1, BlockAgiositeDecorative.BASE_PILLAR.getMeta()), new ItemStack(BlocksAether.icestone_bricks_decorative, 1, BlockAgiositeDecorative.CAPSTONE_BRICKS.getMeta()), new ItemStack(BlocksAether.icestone_bricks_decorative, 1, BlockAgiositeDecorative.CAPSTONE_PILLAR.getMeta()), new ItemStack(BlocksAether.icestone_bricks_decorative, 1, BlockAgiositeDecorative.FLAGSTONES.getMeta()), new ItemStack(BlocksAether.icestone_bricks_decorative, 1, BlockAgiositeDecorative.KEYSTONE.getMeta()), new ItemStack(BlocksAether.icestone_pillar, 1));
        MasonryRecipes.instance().addMasonry(BlocksAether.skyroot_planks, new ItemStack(BlocksAether.skyroot_decorative, 1, BlockSkyrootDecorative.BASE_PLANKS.getMeta()), new ItemStack(BlocksAether.skyroot_decorative, 1, BlockSkyrootDecorative.BASE_BEAM.getMeta()), new ItemStack(BlocksAether.skyroot_decorative, 1, BlockSkyrootDecorative.TOP_PLANKS.getMeta()), new ItemStack(BlocksAether.skyroot_decorative, 1, BlockSkyrootDecorative.TOP_BEAM.getMeta()), new ItemStack(BlocksAether.skyroot_decorative, 1, BlockSkyrootDecorative.FLOORBOARDS.getMeta()), new ItemStack(BlocksAether.skyroot_decorative, 1, BlockSkyrootDecorative.HIGHLIGHT.getMeta()), new ItemStack(BlocksAether.skyroot_decorative, 1, BlockSkyrootDecorative.TILES.getMeta()), new ItemStack(BlocksAether.skyroot_decorative, 1, BlockSkyrootDecorative.TILES_SMALL.getMeta()), new ItemStack(BlocksAether.skyroot_beam, 1));
        MasonryRecipes.instance().addMasonry(BlocksAether.light_skyroot_planks, new ItemStack(BlocksAether.light_skyroot_decorative, 1, BlockSkyrootDecorative.BASE_PLANKS.getMeta()), new ItemStack(BlocksAether.light_skyroot_decorative, 1, BlockSkyrootDecorative.BASE_BEAM.getMeta()), new ItemStack(BlocksAether.light_skyroot_decorative, 1, BlockSkyrootDecorative.TOP_PLANKS.getMeta()), new ItemStack(BlocksAether.light_skyroot_decorative, 1, BlockSkyrootDecorative.TOP_BEAM.getMeta()), new ItemStack(BlocksAether.light_skyroot_decorative, 1, BlockSkyrootDecorative.FLOORBOARDS.getMeta()), new ItemStack(BlocksAether.light_skyroot_decorative, 1, BlockSkyrootDecorative.HIGHLIGHT.getMeta()), new ItemStack(BlocksAether.light_skyroot_decorative, 1, BlockSkyrootDecorative.TILES.getMeta()), new ItemStack(BlocksAether.light_skyroot_decorative, 1, BlockSkyrootDecorative.TILES_SMALL.getMeta()), new ItemStack(BlocksAether.light_skyroot_beam, 1));
        MasonryRecipes.instance().addMasonry(BlocksAether.dark_skyroot_planks, new ItemStack(BlocksAether.dark_skyroot_decorative, 1, BlockSkyrootDecorative.BASE_PLANKS.getMeta()), new ItemStack(BlocksAether.dark_skyroot_decorative, 1, BlockSkyrootDecorative.BASE_BEAM.getMeta()), new ItemStack(BlocksAether.dark_skyroot_decorative, 1, BlockSkyrootDecorative.TOP_PLANKS.getMeta()), new ItemStack(BlocksAether.dark_skyroot_decorative, 1, BlockSkyrootDecorative.TOP_BEAM.getMeta()), new ItemStack(BlocksAether.dark_skyroot_decorative, 1, BlockSkyrootDecorative.FLOORBOARDS.getMeta()), new ItemStack(BlocksAether.dark_skyroot_decorative, 1, BlockSkyrootDecorative.HIGHLIGHT.getMeta()), new ItemStack(BlocksAether.dark_skyroot_decorative, 1, BlockSkyrootDecorative.TILES.getMeta()), new ItemStack(BlocksAether.dark_skyroot_decorative, 1, BlockSkyrootDecorative.TILES_SMALL.getMeta()), new ItemStack(BlocksAether.dark_skyroot_beam, 1));
        MasonryRecipes.instance().addMasonry(BlocksAether.therawood_planks, new ItemStack(BlocksAether.therawood_decorative, 1, BlockTherawoodDecorative.BASE_PLANKS.getMeta()), new ItemStack(BlocksAether.therawood_decorative, 1, BlockTherawoodDecorative.BASE_BEAM.getMeta()), new ItemStack(BlocksAether.therawood_decorative, 1, BlockTherawoodDecorative.TOP_PLANKS.getMeta()), new ItemStack(BlocksAether.therawood_decorative, 1, BlockTherawoodDecorative.TOP_BEAM.getMeta()), new ItemStack(BlocksAether.therawood_decorative, 1, BlockTherawoodDecorative.FLOORBOARDS.getMeta()), new ItemStack(BlocksAether.therawood_decorative, 1, BlockTherawoodDecorative.HIGHLIGHT.getMeta()), new ItemStack(BlocksAether.therawood_beam, 1));
        MasonryRecipes.instance().addMasonry(BlocksAether.quicksoil_glass, new ItemStack(BlocksAether.quicksoil_glass_decorative, 1, BlockQuicksoilGlassDecorative.SKYROOT_FRAME.getMeta()), new ItemStack(BlocksAether.quicksoil_glass_decorative, 1, BlockQuicksoilGlassDecorative.ARKENIUM_FRAME.getMeta()));
        MasonryRecipes.instance().addMasonry(BlocksAether.scatterglass, new ItemStack(BlocksAether.scatterglass_decorative, 1, BlockRockGlassDecorative.SKYROOT_FRAME.getMeta()), new ItemStack(BlocksAether.scatterglass_decorative, 1, BlockRockGlassDecorative.ARKENIUM_FRAME.getMeta()));
        MasonryRecipes.instance().addMasonry(BlocksAether.crude_scatterglass, new ItemStack(BlocksAether.crude_scatterglass_decorative, 1, BlockRockGlassDecorative.SKYROOT_FRAME.getMeta()), new ItemStack(BlocksAether.crude_scatterglass_decorative, 1, BlockRockGlassDecorative.ARKENIUM_FRAME.getMeta()));
        MasonryRecipes.instance().addMasonry(BlocksAether.quicksoil_glass_pane, new ItemStack(BlocksAether.quicksoil_glass_pane_decorative, 1, BlockQuicksoilGlassPaneDecorative.SKYROOT_FRAME.getMeta()), new ItemStack(BlocksAether.quicksoil_glass_pane_decorative, 1, BlockQuicksoilGlassPaneDecorative.ARKENIUM_FRAME.getMeta()));
        MasonryRecipes.instance().addMasonry(BlocksAether.scatterglass_pane, new ItemStack(BlocksAether.scatterglass_pane_decorative, 1, BlockRockGlassPaneDecorative.SKYROOT_FRAME.getMeta()), new ItemStack(BlocksAether.scatterglass_pane_decorative, 1, BlockRockGlassPaneDecorative.ARKENIUM_FRAME.getMeta()));
        MasonryRecipes.instance().addMasonry(BlocksAether.crude_scatterglass_pane, new ItemStack(BlocksAether.crude_scatterglass_pane_decorative, 1, BlockRockGlassPaneDecorative.SKYROOT_FRAME.getMeta()), new ItemStack(BlocksAether.crude_scatterglass_pane_decorative, 1, BlockRockGlassPaneDecorative.ARKENIUM_FRAME.getMeta()));
        MasonryRecipes.instance().addMasonry(BlocksAether.therastone_brick, new ItemStack(BlocksAether.therastone_brick_decorative, 1, BlockTherastoneDecorative.BASE_BRICKS.getMeta()), new ItemStack(BlocksAether.therastone_brick_decorative, 1, BlockTherastoneDecorative.BASE_PILLAR.getMeta()), new ItemStack(BlocksAether.therastone_brick_decorative, 1, BlockTherastoneDecorative.CAPSTONE_BRICKS.getMeta()), new ItemStack(BlocksAether.therastone_brick_decorative, 1, BlockTherastoneDecorative.CAPSTONE_PILLAR.getMeta()), new ItemStack(BlocksAether.therastone_brick_decorative, 1, BlockTherastoneDecorative.FLAGSTONES.getMeta()), new ItemStack(BlocksAether.therastone_brick_decorative, 1, BlockTherastoneDecorative.KEYSTONE.getMeta()), new ItemStack(BlocksAether.therastone_pillar, 1));
        MasonryRecipes.instance().addMasonryItem(ItemsAether.skyroot_door_item, new ItemStack(ItemsAether.secret_skyroot_door_item, 1));
        MasonryRecipes.instance().addMasonry(BlocksAether.skyroot_trapdoor, new ItemStack(BlocksAether.secret_skyroot_trapdoor, 1));
    }

    private static void registerCoolerRecipes() {
        CoolerRecipes.instance().addCoolingFromItem(ItemsAether.irradiated_armor, Item.func_150898_a((Block)Blocks.field_150350_a), new ItemStack(ItemsAether.irradiated_dust), new ItemStack(ItemsAether.arkenium_helmet), new ItemStack(ItemsAether.arkenium_chestplate), new ItemStack(ItemsAether.arkenium_leggings), new ItemStack(ItemsAether.arkenium_boots), new ItemStack(ItemsAether.arkenium_gloves), new ItemStack(ItemsAether.gravitite_helmet), new ItemStack(ItemsAether.gravitite_chestplate), new ItemStack(ItemsAether.gravitite_leggings), new ItemStack(ItemsAether.gravitite_boots), new ItemStack(ItemsAether.gravitite_gloves), new ItemStack(ItemsAether.zanite_helmet), new ItemStack(ItemsAether.zanite_chestplate), new ItemStack(ItemsAether.zanite_leggings), new ItemStack(ItemsAether.zanite_boots), new ItemStack(ItemsAether.zanite_gloves));
        CoolerRecipes.instance().addCoolingFromItem(ItemsAether.irradiated_charm, Item.func_150898_a((Block)Blocks.field_150350_a), new ItemStack(ItemsAether.irradiated_dust), new ItemStack(ItemsAether.irradiated_dust));
        CoolerRecipes.instance().addCoolingFromItem(ItemsAether.irradiated_chunk, Item.func_150898_a((Block)Blocks.field_150350_a), new ItemStack(ItemsAether.irradiated_dust), new ItemStack(ItemsAether.irradiated_dust));
        CoolerRecipes.instance().addCoolingFromItem(ItemsAether.irradiated_neckwear, Item.func_150898_a((Block)Blocks.field_150350_a), new ItemStack(ItemsAether.irradiated_dust), new ItemStack(ItemsAether.irradiated_dust));
        CoolerRecipes.instance().addCoolingFromItem(ItemsAether.irradiated_ring, Item.func_150898_a((Block)Blocks.field_150350_a), new ItemStack(ItemsAether.irradiated_dust), new ItemStack(ItemsAether.irradiated_dust));
        CoolerRecipes.instance().addCoolingFromItem(ItemsAether.irradiated_sword, Item.func_150898_a((Block)Blocks.field_150350_a), new ItemStack(ItemsAether.irradiated_dust), new ItemStack(ItemsAether.arkenium_sword), new ItemStack(ItemsAether.gravitite_sword), new ItemStack(ItemsAether.holystone_sword), new ItemStack(ItemsAether.zanite_sword), new ItemStack(ItemsAether.skyroot_sword));
        CoolerRecipes.instance().addCoolingFromItem(ItemsAether.irradiated_tool, Item.func_150898_a((Block)Blocks.field_150350_a), new ItemStack(ItemsAether.irradiated_dust), new ItemStack(ItemsAether.arkenium_axe), new ItemStack(ItemsAether.arkenium_pickaxe), new ItemStack(ItemsAether.arkenium_shovel), new ItemStack(ItemsAether.zanite_axe), new ItemStack(ItemsAether.zanite_pickaxe), new ItemStack(ItemsAether.zanite_shovel), new ItemStack(ItemsAether.gravitite_axe), new ItemStack(ItemsAether.gravitite_pickaxe), new ItemStack(ItemsAether.gravitite_shovel), new ItemStack(ItemsAether.holystone_axe), new ItemStack(ItemsAether.holystone_pickaxe), new ItemStack(ItemsAether.holystone_shovel), new ItemStack(ItemsAether.skyroot_axe), new ItemStack(ItemsAether.skyroot_pickaxe), new ItemStack(ItemsAether.skyroot_shovel));
        CoolerRecipes.instance().addCoolingFromItem(ItemsAether.skyroot_bucket, Item.func_150898_a((Block)BlocksAether.aercloud), null, new ItemStack(ItemsAether.skyroot_water_bucket));
        CoolerRecipes.instance().addCoolingFromItem(ItemsAether.water_vial, ItemsAether.valkyrie_wings, null, new ItemStack(ItemsAether.valkyrie_tea));
        CoolerRecipes.instance().addCoolingFromItem(ItemsAether.skyroot_water_bucket, Item.func_150898_a((Block)Blocks.field_150350_a), new ItemStack(ItemsAether.skyroot_bucket), new ItemStack(BlocksAether.highlands_ice));
    }

    private static void addMasonry(ItemStack result, Object ... required) {
        AetherAPI.content().masonry().registerRecipe(new SimpleRecipe(result, required));
    }

    private static void registerSmeltingRecipe(ItemStack input, ItemStack output, float xp) {
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)xp);
    }

    public static void bakeRecipes() {
        AetherCore.PROXY.content().masonry().finalizeRecipes();
    }
}

