/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.init;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.items.EffectActivator;
import com.gildedgames.aether.api.items.equipment.ItemEquipmentSlot;
import com.gildedgames.aether.api.items.equipment.effects.IEffectProvider;
import com.gildedgames.aether.api.items.properties.ItemPropertiesBuilder;
import com.gildedgames.aether.api.items.properties.ItemRarity;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.capabilities.item.effects.CompanionEffectFactory;
import com.gildedgames.aether.common.capabilities.item.effects.FireImmunityEffectFactory;
import com.gildedgames.aether.common.capabilities.item.effects.InvisiblityEffectFactory;
import com.gildedgames.aether.common.capabilities.item.effects.PotionEffectFactory;
import com.gildedgames.aether.common.capabilities.item.effects.RegenerationEffectFactory;
import com.gildedgames.aether.common.capabilities.item.effects.WaterBreathEffectFactory;
import com.gildedgames.aether.common.capabilities.item.effects.stats.StatEffectFactory;
import com.gildedgames.aether.common.entities.companions.EntityCompanion;
import com.gildedgames.aether.common.items.companions.ItemCompanion;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.Item;

public class EquipmentAether {
    private static final EffectActivator[] EMPTY_ACTIVATORS = new EffectActivator[0];
    private static final EffectActivator[] WHEN_HELD = new EffectActivator[]{EffectActivator.WHEN_HELD};
    private static final EffectActivator[] WHEN_EQUIPPED = new EffectActivator[]{EffectActivator.WHEN_EQUIPPED};

    public static void init() {
        EquipmentAether.registerProcessors();
        EquipmentAether.registerItems();
    }

    private static void registerProcessors() {
        AetherAPI.content().effects().registerEffect(new RegenerationEffectFactory());
        AetherAPI.content().effects().registerEffect(new WaterBreathEffectFactory());
        AetherAPI.content().effects().registerEffect(new FireImmunityEffectFactory());
        AetherAPI.content().effects().registerEffect(new StatEffectFactory());
        AetherAPI.content().effects().registerEffect(new PotionEffectFactory());
        AetherAPI.content().effects().registerEffect(new CompanionEffectFactory());
        AetherAPI.content().effects().registerEffect(new InvisiblityEffectFactory());
    }

    private static void registerItems() {
        EquipmentAether.createEquipmentItem(ItemsAether.taegore_hide_gloves, ItemEquipmentSlot.HANDWEAR, ItemRarity.NONE, WHEN_EQUIPPED, new IEffectProvider[0]);
        EquipmentAether.createEquipmentItem(ItemsAether.burrukai_pelt_gloves, ItemEquipmentSlot.HANDWEAR, ItemRarity.NONE, WHEN_EQUIPPED, new IEffectProvider[0]);
        EquipmentAether.createEquipmentItem(ItemsAether.zanite_gloves, ItemEquipmentSlot.HANDWEAR, ItemRarity.NONE, WHEN_EQUIPPED, new IEffectProvider[0]);
        EquipmentAether.createEquipmentItem(ItemsAether.arkenium_gloves, ItemEquipmentSlot.HANDWEAR, ItemRarity.NONE, WHEN_EQUIPPED, new StatEffectFactory.StatProvider(SharedMonsterAttributes.field_111263_d, -0.075, 1));
        EquipmentAether.createEquipmentItem(ItemsAether.gravitite_gloves, ItemEquipmentSlot.HANDWEAR, ItemRarity.NONE, WHEN_EQUIPPED, new IEffectProvider[0]);
    }

    private static void createEquipmentItem(Item item, ItemEquipmentSlot slot, ItemRarity rarity) {
        EquipmentAether.createEquipmentItem(item, slot, rarity, EMPTY_ACTIVATORS, new IEffectProvider[0]);
    }

    private static void createEquipmentItem(Item item, ItemEquipmentSlot slot, ItemRarity rarity, EffectActivator[] effectActivators, IEffectProvider ... providers) {
        ItemPropertiesBuilder builder = new ItemPropertiesBuilder();
        builder.withSlot(slot);
        builder.withRarity(rarity);
        for (IEffectProvider provider : providers) {
            builder.withEffect(provider);
        }
        builder.withEffectActivators(effectActivators);
        AetherAPI.content().items().registerItem(item, builder);
    }

    private static void createCompanionItem(Item item, ItemEquipmentSlot slot, ItemRarity rarity, Class<? extends EntityCompanion> companion, IEffectProvider ... providers) {
        ItemPropertiesBuilder builder = new ItemPropertiesBuilder();
        builder.withSlot(slot);
        builder.withRarity(rarity);
        builder.withEffect(new CompanionEffectFactory.CompanionEffectProvider(companion));
        builder.withPrecondition((player, stack) -> !(stack.func_77973_b() instanceof ItemCompanion) || ItemCompanion.getTicksUntilRespawn(stack, player.getEntity().func_130014_f_()) <= 0L);
        for (IEffectProvider provider : providers) {
            builder.withEffect(provider);
        }
        AetherAPI.content().items().registerItem(item, builder);
    }
}

