/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.init;

import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.world.biomes.BiomeAetherBase;
import com.gildedgames.aether.common.world.biomes.BiomeInstancedZone;
import com.gildedgames.aether.common.world.biomes.BiomeVoid;
import com.gildedgames.aether.common.world.biomes.arctic_peaks.BiomeArcticPeaks;
import com.gildedgames.aether.common.world.biomes.forgotten_highlands.BiomeForgottenHighlands;
import com.gildedgames.aether.common.world.biomes.highlands.BiomeHighlands;
import com.gildedgames.aether.common.world.biomes.irradiated_forests.BiomeIrradiatedForests;
import com.gildedgames.aether.common.world.biomes.magnetic_hills.BiomeMagneticHills;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
@GameRegistry.ObjectHolder(value="aether")
public class BiomesAetherInit {
    private static final BiomeAetherBase HIGHLANDS = new BiomeHighlands(new Biome.BiomeProperties("Highlands").func_185410_a(0.5f).func_185402_a(7396208), AetherCore.getResource("aether_highlands"));
    private static final BiomeAetherBase MAGNETIC_HILLS = new BiomeMagneticHills(new Biome.BiomeProperties("Magnetic Hills").func_185410_a(0.5f).func_185402_a(7396208), AetherCore.getResource("aether_magnetic_hills"));
    private static final BiomeAetherBase ARCTIC_PEAKS = new BiomeArcticPeaks(new Biome.BiomeProperties("Arctic Peaks").func_185396_a().func_185411_b().func_185410_a(0.0f).func_185402_a(7396208), AetherCore.getResource("aether_arctic_peaks"));
    private static final BiomeAetherBase FORGOTTEN_HIGHLANDS = new BiomeForgottenHighlands(new Biome.BiomeProperties("Forgotten Highlands").func_185410_a(0.0f).func_185402_a(7396208), AetherCore.getResource("aether_forgotten_highlands"));
    private static final BiomeAetherBase IRRADIATED_FORESTS = new BiomeIrradiatedForests(new Biome.BiomeProperties("Irradiated Forests").func_185410_a(0.0f).func_185402_a(14597171), AetherCore.getResource("aether_irradiated_forests"));
    private static final Biome VOID = new BiomeVoid();
    private static final Biome INSTANCED_ZONE = new BiomeInstancedZone();
    private static final List<BiomeAetherBase> POSSIBLE_BIOMES = Lists.newArrayList();

    @SubscribeEvent
    public static void registerBiome(RegistryEvent.Register<Biome> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Biome[]{HIGHLANDS, MAGNETIC_HILLS, ARCTIC_PEAKS, FORGOTTEN_HIGHLANDS, IRRADIATED_FORESTS, VOID, INSTANCED_ZONE});
        BiomeDictionary.addTypes((Biome)HIGHLANDS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        BiomeDictionary.addTypes((Biome)MAGNETIC_HILLS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE});
        BiomeDictionary.addTypes((Biome)ARCTIC_PEAKS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.DENSE});
        BiomeDictionary.addTypes((Biome)FORGOTTEN_HIGHLANDS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DENSE});
        BiomeDictionary.addTypes((Biome)IRRADIATED_FORESTS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE});
        BiomeDictionary.addTypes((Biome)VOID, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.VOID});
        BiomeDictionary.addTypes((Biome)INSTANCED_ZONE, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.VOID});
        BiomesAetherInit.registerPossibleBiome(HIGHLANDS, MAGNETIC_HILLS, ARCTIC_PEAKS, FORGOTTEN_HIGHLANDS, IRRADIATED_FORESTS);
    }

    public static void registerPossibleBiome(BiomeAetherBase ... biomes) {
        POSSIBLE_BIOMES.addAll(Arrays.asList(biomes));
    }

    public static float getTotalBiomeWeight() {
        float total = 0.0f;
        for (BiomeAetherBase b : POSSIBLE_BIOMES) {
            total += b.getRarityWeight();
        }
        return total;
    }

    public static BiomeAetherBase fetchRandomBiome(Random rand) {
        float randomValue = rand.nextFloat() * BiomesAetherInit.getTotalBiomeWeight();
        float chanceSum = 0.0f;
        for (BiomeAetherBase b : POSSIBLE_BIOMES) {
            if (b.getRarityWeight() + chanceSum >= randomValue) {
                return b;
            }
            chanceSum += b.getRarityWeight();
        }
        return null;
    }
}

