/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.events.listeners.world;

import com.gildedgames.aether.api.registrar.BiomesAether;
import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.aether.api.world.spawn.ISpawnHandler;
import com.gildedgames.aether.api.world.spawn.ISpawnSystem;
import com.gildedgames.aether.common.entities.animals.EntityAerbunny;
import com.gildedgames.aether.common.entities.animals.EntityBurrukai;
import com.gildedgames.aether.common.entities.animals.EntityCarrionSprout;
import com.gildedgames.aether.common.entities.animals.EntityGlactrix;
import com.gildedgames.aether.common.entities.animals.EntityGlitterwing;
import com.gildedgames.aether.common.entities.animals.EntityKirrid;
import com.gildedgames.aether.common.entities.animals.EntitySheepuff;
import com.gildedgames.aether.common.entities.animals.EntityTaegore;
import com.gildedgames.aether.common.entities.monsters.EntityAechorPlant;
import com.gildedgames.aether.common.entities.monsters.EntityCockatrice;
import com.gildedgames.aether.common.entities.monsters.EntitySwet;
import com.gildedgames.aether.common.entities.monsters.EntityTempest;
import com.gildedgames.aether.common.entities.monsters.EntityVaranys;
import com.gildedgames.aether.common.entities.monsters.EntityZephyr;
import com.gildedgames.aether.common.init.DimensionsAether;
import com.gildedgames.aether.common.world.spawning.SpawnEntry;
import com.gildedgames.aether.common.world.spawning.SpawnHandler;
import com.gildedgames.aether.common.world.spawning.conditions.CheckBannedBiomes;
import com.gildedgames.aether.common.world.spawning.conditions.CheckBiome;
import com.gildedgames.aether.common.world.spawning.conditions.CheckBlockAtPosition;
import com.gildedgames.aether.common.world.spawning.conditions.CheckBlockStateUnderneath;
import com.gildedgames.aether.common.world.spawning.conditions.CheckBlockUnderneath;
import com.gildedgames.aether.common.world.spawning.conditions.CheckDimension;
import com.gildedgames.aether.common.world.spawning.conditions.CheckIsUnderground;
import com.gildedgames.aether.common.world.spawning.conditions.CheckLightLevel;
import com.gildedgames.aether.common.world.spawning.conditions.CheckTime;
import com.gildedgames.aether.common.world.spawning.util.FlyingPositionSelector;
import com.gildedgames.aether.common.world.spawning.util.OffsetFromTopBlockPositionSelector;
import com.gildedgames.aether.common.world.spawning.util.UndergroundPositionSelector;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class WorldTickListener {
    public static List<ISpawnHandler> getSpawnHandlers(World world) {
        if (world.field_73011_w.func_186058_p() != DimensionsAether.AETHER) {
            return Collections.emptyList();
        }
        CheckBlockUnderneath grassCheck = new CheckBlockUnderneath(BlocksAether.aether_grass);
        CheckBlockUnderneath iceCheck = new CheckBlockUnderneath(BlocksAether.highlands_packed_ice, BlocksAether.highlands_ice, BlocksAether.aether_grass);
        CheckBlockUnderneath groundCheck = new CheckBlockUnderneath(BlocksAether.aether_grass, BlocksAether.holystone);
        CheckBlockUnderneath stoneCheck = new CheckBlockUnderneath(BlocksAether.holystone);
        CheckIsUnderground isUnderground = new CheckIsUnderground();
        CheckBiome arcticPeaks = new CheckBiome(BiomesAether.ARCTIC_PEAKS);
        CheckBannedBiomes notForgot = new CheckBannedBiomes(BiomesAether.FORGOTTEN_HIGHLANDS);
        CheckBiome forgottenHighlands = new CheckBiome(BiomesAether.FORGOTTEN_HIGHLANDS);
        SpawnHandler animals = new SpawnHandler("aether_animals").chunkArea(4).targetEntityCountPerArea(9).updateFrequencyInTicks(200);
        animals.addWorldCondition(new CheckDimension(DimensionsAether.AETHER));
        SpawnEntry burrukai = new SpawnEntry(EntityLiving.SpawnPlacementType.ON_GROUND, EntityBurrukai.class, 10.0f, 2, 3).addCondition(grassCheck).addCondition(notForgot);
        SpawnEntry ram = new SpawnEntry(EntityLiving.SpawnPlacementType.ON_GROUND, EntityKirrid.class, 10.0f, 2, 3).addCondition(grassCheck).addCondition(notForgot);
        SpawnEntry aerbunny = new SpawnEntry(EntityLiving.SpawnPlacementType.ON_GROUND, EntityAerbunny.class, 13.0f, 3, 5).addCondition(grassCheck).addCondition(notForgot);
        SpawnEntry taegore = new SpawnEntry(EntityLiving.SpawnPlacementType.ON_GROUND, EntityTaegore.class, 13.0f, 2, 3).addCondition(grassCheck).addCondition(notForgot);
        SpawnEntry carrion_sprout = new SpawnEntry(EntityLiving.SpawnPlacementType.ON_GROUND, EntityCarrionSprout.class, 10.0f, 2, 3).addCondition(grassCheck).addCondition(notForgot);
        SpawnEntry glactrix = new SpawnEntry(EntityLiving.SpawnPlacementType.ON_GROUND, EntityGlactrix.class, 14.0f, 2, 3).addCondition(arcticPeaks).addCondition(iceCheck).addCondition(notForgot);
        animals.addEntry(burrukai);
        animals.addEntry(ram);
        animals.addEntry(aerbunny);
        animals.addEntry(taegore);
        animals.addEntry(carrion_sprout);
        animals.addEntry(glactrix);
        SpawnEntry sheepuff = new SpawnEntry(EntityLiving.SpawnPlacementType.ON_GROUND, EntitySheepuff.class, 10.0f, 2, 3).addCondition(grassCheck).addCondition(forgottenHighlands);
        animals.addEntry(sheepuff);
        SpawnHandler atmospheric = new SpawnHandler("aether_atmospheric").chunkArea(4).targetEntityCountPerArea(9).updateFrequencyInTicks(200);
        atmospheric.addWorldCondition(new CheckDimension(DimensionsAether.AETHER));
        SpawnEntry butterfly = new SpawnEntry(EntityLiving.SpawnPlacementType.IN_AIR, EntityGlitterwing.class, 10.0f, 1, 6).addCondition(grassCheck);
        atmospheric.addEntry(butterfly);
        SpawnHandler daytimeHostiles = new SpawnHandler("aether_daytime_hostiles").chunkArea(4).targetEntityCountPerArea(9).updateFrequencyInTicks(1200);
        daytimeHostiles.addWorldCondition(new CheckDimension(DimensionsAether.AETHER));
        SpawnEntry zephyr = new SpawnEntry(EntityLiving.SpawnPlacementType.IN_AIR, EntityZephyr.class, 5.0f, 1, 1, new OffsetFromTopBlockPositionSelector(15)).addCondition(new CheckBlockStateUnderneath(Blocks.field_150350_a.func_176223_P())).addCondition(new CheckBlockAtPosition(Blocks.field_150350_a)).addCondition(notForgot);
        SpawnEntry swet = new SpawnEntry(EntityLiving.SpawnPlacementType.ON_GROUND, EntitySwet.class, 10.0f, 2, 4).addCondition(groundCheck).addCondition(notForgot);
        SpawnEntry aechor_plant = new SpawnEntry(EntityLiving.SpawnPlacementType.ON_GROUND, EntityAechorPlant.class, 10.0f, 2, 3).addCondition(grassCheck);
        daytimeHostiles.addEntry(zephyr);
        daytimeHostiles.addEntry(swet);
        daytimeHostiles.addEntry(aechor_plant);
        SpawnHandler nighttimeHostiles = new SpawnHandler("aether_nighttime_hostiles").chunkArea(4).targetEntityCountPerArea(5).updateFrequencyInTicks(1200);
        nighttimeHostiles.addWorldCondition(new CheckDimension(DimensionsAether.AETHER));
        nighttimeHostiles.addWorldCondition(new CheckTime(CheckTime.Time.NIGHT));
        SpawnEntry tempest = new SpawnEntry(EntityLiving.SpawnPlacementType.IN_AIR, EntityTempest.class, 3.0f, 1, 1, new FlyingPositionSelector()).addCondition(new CheckBlockStateUnderneath(Blocks.field_150350_a.func_176223_P())).addCondition(new CheckTime(CheckTime.Time.NIGHT)).addCondition(new CheckBlockAtPosition(Blocks.field_150350_a)).addCondition(notForgot);
        SpawnEntry cockatrice = new SpawnEntry(EntityLiving.SpawnPlacementType.ON_GROUND, EntityCockatrice.class, 12.0f, 2, 3).addCondition(groundCheck).addCondition(new CheckTime(CheckTime.Time.NIGHT));
        SpawnEntry varanys = new SpawnEntry(EntityLiving.SpawnPlacementType.ON_GROUND, EntityVaranys.class, 10.0f, 1, 2).addCondition(groundCheck).addCondition(new CheckTime(CheckTime.Time.NIGHT)).addCondition(arcticPeaks);
        nighttimeHostiles.addEntry(tempest);
        nighttimeHostiles.addEntry(cockatrice);
        nighttimeHostiles.addEntry(varanys);
        SpawnHandler flying = new SpawnHandler("aether_flying").chunkArea(20).targetEntityCountPerArea(1).updateFrequencyInTicks(1200);
        flying.addWorldCondition(new CheckDimension(DimensionsAether.AETHER));
        SpawnHandler underground = new SpawnHandler("aether_underground").chunkArea(4).targetEntityCountPerArea(10).updateFrequencyInTicks(1200);
        daytimeHostiles.addWorldCondition(new CheckDimension(DimensionsAether.AETHER));
        SpawnEntry cockatriceUnderground = new SpawnEntry(EntityLiving.SpawnPlacementType.ON_GROUND, EntityCockatrice.class, 12.0f, 1, 3, new UndergroundPositionSelector()).addCondition(stoneCheck).addCondition(isUnderground).addCondition(new CheckBlockAtPosition(Blocks.field_150350_a));
        SpawnEntry varanysUnderground = new SpawnEntry(EntityLiving.SpawnPlacementType.ON_GROUND, EntityVaranys.class, 20.0f, 1, 3, new UndergroundPositionSelector()).addCondition(stoneCheck).addCondition(isUnderground).addCondition(arcticPeaks).addCondition(new CheckLightLevel(5)).addCondition(new CheckBlockAtPosition(Blocks.field_150350_a));
        SpawnEntry tempestUnderground = new SpawnEntry(EntityLiving.SpawnPlacementType.ON_GROUND, EntityTempest.class, 10.0f, 2, 3, new UndergroundPositionSelector()).addCondition(stoneCheck).addCondition(isUnderground).addCondition(new CheckBlockAtPosition(Blocks.field_150350_a)).addCondition(notForgot);
        underground.addEntry(cockatriceUnderground);
        underground.addEntry(tempestUnderground);
        underground.addEntry(varanysUnderground);
        return Lists.newArrayList((Object[])new ISpawnHandler[]{animals, atmospheric, daytimeHostiles, nighttimeHostiles, flying, underground});
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ISpawnSystem system;
            World world = event.world;
            if (!world.field_72995_K && world.func_82736_K().func_82766_b("doMobSpawning") && (system = (ISpawnSystem)event.world.getCapability(CapabilitiesAether.SPAWN_SYSTEM, null)) != null) {
                system.tick();
            }
        }
    }
}

