/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.events.listeners.player;

import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerTeleportingModule;
import com.gildedgames.aether.common.containers.ContainerLoadingScreen;
import com.gildedgames.aether.common.events.PostAetherTravelEvent;
import com.gildedgames.aether.common.init.DimensionsAether;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.PacketCloseLoadingScreen;
import com.gildedgames.aether.common.network.packets.PacketLoadingScreenPercent;
import com.gildedgames.aether.common.util.helpers.AetherHelper;
import com.gildedgames.aether.common.util.helpers.MathUtil;
import com.gildedgames.aether.common.world.preparation.PrepHelper;
import com.gildedgames.orbis.lib.util.mc.BlockPosDimension;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Mod.EventBusSubscriber
public class PlayerTeleportListener {
    @SubscribeEvent
    public static void onEvent(EntityTravelToDimensionEvent event) {
        if (AetherHelper.isEnabled(event.getDimension()) && AetherHelper.isEnabled(event.getDimension())) {
            PlayerAether playerAether = PlayerAether.getPlayer((EntityPlayer)event.getEntity());
            if (!AetherHelper.isNecromancerTower(event.getEntity().field_71093_bK)) {
                playerAether.getModule(PlayerTeleportingModule.class).setNonAetherPos(new BlockPosDimension(event.getEntity().func_180425_c(), event.getEntity().field_71093_bK));
            }
        }
    }

    @SubscribeEvent
    public static void onEvent(PostAetherTravelEvent event) {
        if (!event.getEntity().func_130014_f_().field_72995_K && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            player.openGui((Object)AetherCore.INSTANCE, 9, player.func_130014_f_(), player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
        }
    }

    @SubscribeEvent
    public static void onEvent(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntity().func_130014_f_().field_72995_K && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            PlayerAether playerAether = PlayerAether.getPlayer(player);
            if (player.func_130014_f_().field_73011_w.func_186058_p() != DimensionsAether.AETHER) {
                return;
            }
            PlayerTeleportingModule teleportingModule = playerAether.getModule(PlayerTeleportingModule.class);
            if (player.field_71070_bA instanceof ContainerLoadingScreen && PrepHelper.isSectorLoaded(player.func_130014_f_(), player.field_70176_ah, player.field_70164_aj)) {
                boolean isLoaded = true;
                int radius = Math.min(player.func_184102_h().func_184103_al().func_72395_o(), 10);
                int count = 0;
                for (int x = player.field_70176_ah - radius; x < player.field_70176_ah + radius; ++x) {
                    for (int z = player.field_70164_aj - radius; z < player.field_70164_aj + radius; ++z) {
                        Chunk chunk = player.field_70170_p.func_72863_F().func_186026_b(x, z);
                        if (chunk == null) {
                            isLoaded = false;
                            continue;
                        }
                        ++count;
                    }
                }
                if (isLoaded) {
                    player.func_71053_j();
                    NetworkingAether.sendPacketToPlayer(new PacketCloseLoadingScreen(), (EntityPlayerMP)player);
                    NetworkingAether.sendPacketToPlayer(new PacketLoadingScreenPercent(0.0f), (EntityPlayerMP)player);
                    ArrayList toUnlock = Lists.newArrayList();
                    for (IRecipe r : ForgeRegistries.RECIPES) {
                        ResourceLocation loc = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)r.func_77571_b().func_77973_b());
                        if (loc == null || !loc.func_110624_b().equals("aether")) continue;
                        toUnlock.add(r);
                    }
                    player.func_192021_a((List)toUnlock);
                } else {
                    float diam = radius + radius;
                    float percent = (float)count / (diam * diam) * 100.0f;
                    if (!MathUtil.epsilonEquals(teleportingModule.getLastPercent(), percent)) {
                        teleportingModule.setLastPercent(percent);
                        NetworkingAether.sendPacketToPlayer(new PacketLoadingScreenPercent(percent), (EntityPlayerMP)player);
                    }
                }
            }
        }
    }
}

