/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.events.listeners.player;

import com.gildedgames.aether.api.entity.IMount;
import com.gildedgames.aether.api.entity.IMountProcessor;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.entities.mounts.IFlyingMountData;
import com.gildedgames.aether.common.entities.multipart.AetherMultiPartMount;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class PlayerMountListener {
    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        IMount mount;
        IMountProcessor processor;
        Entity target = event.getTarget();
        if (target instanceof AetherMultiPartMount) {
            target = ((AetherMultiPartMount)target).getEntity();
        }
        if (target instanceof IMount && (processor = (mount = (IMount)target).getMountProcessor()).canBeMounted(target) && !event.getEntityPlayer().func_184218_aH() && processor.canProcessMountInteraction(event.getTarget(), (Entity)event.getEntityPlayer())) {
            if (target.func_184188_bt().contains(event.getEntityPlayer())) {
                event.getEntityPlayer().func_110145_l(target);
                processor.onDismountedBy(target, (Entity)event.getEntityPlayer());
            } else {
                if (!event.getWorld().field_72995_K) {
                    event.getEntityPlayer().func_184220_m(target);
                }
                processor.onMountedBy(target, (Entity)event.getEntityPlayer());
                AetherCore.PROXY.displayDismountMessage(event.getEntityPlayer());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        Entity riding;
        if (event.getEntity() instanceof EntityPlayer && (riding = (player = (EntityPlayer)event.getEntity()).func_184187_bx()) instanceof IMount && riding instanceof EntityLivingBase) {
            IMount mount = (IMount)riding;
            IMountProcessor processor = mount.getMountProcessor();
            EntityLivingBase livingMount = (EntityLivingBase)riding;
            livingMount.field_70761_aq = player.field_70761_aq;
            livingMount.func_70637_d(false);
            livingMount.field_70702_br = 0.0f;
            livingMount.field_191988_bg = 0.0f;
            livingMount.field_70704_bt = 0.0f;
            livingMount.field_70138_W = processor.getMountedStepHeight((Entity)livingMount);
            PlayerMountListener.processSteering(mount, livingMount, player);
            processor.onUpdate((Entity)livingMount, (Entity)player);
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingAttackEvent event) {
        if (event.getEntity() instanceof IMount && !event.getEntity().func_184188_bt().isEmpty()) {
            Entity riding = (Entity)event.getEntity().func_184188_bt().get(0);
            if (event.getSource().func_76346_g() == riding) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onMountEvent(EntityMountEvent event) {
        Entity entity = event.getEntityBeingMounted();
        if (event.isDismounting() && entity instanceof IMount && !entity.field_70170_p.field_72995_K && (!entity.field_70122_E || entity instanceof IFlyingMountData && ((IFlyingMountData)entity).isFastFalling())) {
            event.setCanceled(true);
        }
    }

    private static void processSteering(IMount mountImpl, EntityLivingBase mount, EntityPlayer rider) {
        boolean riderIsJumping;
        IMountProcessor processor = mountImpl.getMountProcessor();
        if (mount instanceof EntityCreature) {
            ((EntityCreature)mount).func_70661_as().func_75499_g();
        }
        mount.func_70659_e((float)mount.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
        mount.field_70126_B = mount.field_70177_z = rider.field_70177_z;
        mount.field_70125_A = rider.field_70125_A * 0.5f;
        mount.field_70177_z %= 360.0f;
        mount.field_70125_A %= 360.0f;
        mount.field_70759_as = mount.field_70761_aq = mount.field_70177_z;
        float strafe = rider.field_70702_br * 0.5f;
        float forward = rider.field_191988_bg * (mount.field_70122_E ? 0.5f : 1.0f);
        if (forward <= 0.0f) {
            forward *= 0.25f;
        }
        if (riderIsJumping = rider.field_70703_bu) {
            processor.onHoldSpaceBar((Entity)mount, (Entity)rider);
            mount.field_70160_al = true;
        }
        mount.field_70747_aH = mount.func_70689_ay() * 0.1f;
        double oldMotionY = mount.field_70181_x;
        mount.field_70181_x = 0.0;
        float oldLimbSwingAmount = mount.field_70721_aZ;
        float oldPrevLimbSwingAmount = mount.field_184618_aE;
        float oldLimbSwing = mount.field_184619_aG;
        mount.field_184619_aG = 0.0f;
        mount.field_70721_aZ = 0.0f;
        mount.field_184618_aE = 0.0f;
        if ((strafe > 0.0f || strafe < 0.0f) && (forward > 0.0f || forward < 0.0f)) {
            strafe *= 0.5f;
            forward *= 0.5f;
        }
        float f6 = 0.91f;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185345_c((double)mount.field_70165_t, (double)(mount.func_174813_aQ().field_72338_b - 1.0), (double)mount.field_70161_v);
        if (mount.field_70122_E) {
            IBlockState underState = mount.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
            f6 = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)mount.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos, (Entity)mount) * 0.91f;
        }
        float f7 = 0.16277136f / (f6 * f6 * f6);
        float friction = mount.field_70122_E ? mount.func_70689_ay() * f7 : mount.field_70747_aH;
        mount.func_191958_b(strafe, 0.0f, forward, friction);
        mount.field_70721_aZ = oldLimbSwingAmount;
        mount.field_184618_aE = oldPrevLimbSwingAmount;
        mount.field_184619_aG = oldLimbSwing;
        mount.field_70181_x = oldMotionY;
    }
}

