/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.events.listeners.player;

import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerCampfiresModule;
import com.gildedgames.aether.common.init.DimensionsAether;
import com.gildedgames.orbis.lib.util.mc.BlockPosDimension;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class PlayerAetherListener {
    @SubscribeEvent
    public static void onBeginWatching(PlayerEvent.StartTracking event) {
        if (!(event.getTarget() instanceof EntityPlayer)) {
            return;
        }
        PlayerAether aeSourcePlayer = PlayerAether.getPlayer(event.getEntityPlayer());
        PlayerAether aeTargetPlayer = PlayerAether.getPlayer((EntityPlayer)event.getTarget());
        aeTargetPlayer.onPlayerBeginWatching(aeSourcePlayer);
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerAether aePlayer = PlayerAether.getPlayer(event.player);
        aePlayer.onLoggedOut();
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        PlayerAether aePlayer = PlayerAether.getPlayer((EntityPlayer)event.getEntity());
        aePlayer.onDeath(event);
        if (aePlayer.getEntity().field_70170_p.field_73011_w.func_186058_p() == DimensionsAether.AETHER) {
            aePlayer.getModule(PlayerCampfiresModule.class).setDeathPos(new BlockPosDimension(event.getEntity().func_180425_c(), aePlayer.getEntity().field_71093_bK));
        }
    }

    @SubscribeEvent
    public static void onDrops(PlayerDropsEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        PlayerAether aePlayer = PlayerAether.getPlayer((EntityPlayer)event.getEntity());
        aePlayer.onDrops(event);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerAether aePlayer = PlayerAether.getPlayer(event.player);
        aePlayer.onPlayerTick(event);
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        PlayerAether aePlayer = PlayerAether.getPlayer((EntityPlayer)event.getEntity());
        aePlayer.onFall(event);
    }

    @SubscribeEvent
    public static void onCalculateBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        PlayerAether aePlayer = PlayerAether.getPlayer((EntityPlayer)event.getEntity());
        event.setNewSpeed(event.getOriginalSpeed() * aePlayer.getMiningSpeedMultiplier());
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        PlayerAether oldPlayer = PlayerAether.getPlayer(event.getOriginal());
        PlayerAether newPlayer = PlayerAether.getPlayer((EntityPlayer)event.getEntity());
        Capability.IStorage storage = CapabilitiesAether.PLAYER_DATA.getStorage();
        NBTBase state = storage.writeNBT(CapabilitiesAether.PLAYER_DATA, (Object)oldPlayer, null);
        storage.readNBT(CapabilitiesAether.PLAYER_DATA, (Object)newPlayer, null, state);
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerAether aePlayer = PlayerAether.getPlayer(event.player);
        aePlayer.onTeleport(event);
    }
}

