/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.events.listeners.items;

import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.init.MaterialsAether;
import com.gildedgames.aether.common.items.tools.handlers.IToolEventHandler;
import com.gildedgames.aether.common.items.tools.handlers.ItemArkeniumToolHandler;
import com.gildedgames.aether.common.items.tools.handlers.ItemGravititeToolHandler;
import com.gildedgames.aether.common.items.tools.handlers.ItemHolystoneToolHandler;
import com.gildedgames.aether.common.items.tools.handlers.ItemSkyrootToolHandler;
import com.gildedgames.aether.common.items.tools.handlers.ItemZaniteToolHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ItemToolListener {
    private static final Map<String, IToolEventHandler> handlers = new HashMap<String, IToolEventHandler>();

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b() instanceof ItemTool) {
            String material = ((ItemTool)event.getItemStack().func_77973_b()).func_77861_e();
            IToolEventHandler handler = handlers.get(material);
            if (handler == null) {
                return;
            }
            handler.addInformation(event.getItemStack(), event.getToolTip());
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getItemStack().func_77973_b() instanceof ItemTool) {
            String material = ((ItemTool)event.getItemStack().func_77973_b()).func_77861_e();
            IToolEventHandler handler = handlers.get(material);
            if (handler == null) {
                return;
            }
            handler.onRightClickItem(event.getEntityPlayer(), event.getHand());
        }
    }

    @SubscribeEvent
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().func_77973_b() instanceof ItemTool) {
            String material = ((ItemTool)event.getItemStack().func_77973_b()).func_77861_e();
            IToolEventHandler handler = handlers.get(material);
            if (handler == null) {
                return;
            }
            boolean result = handler.onRightClickBlock(event.getWorld(), event.getPos(), event.getEntityPlayer(), event.getHand(), event.getFace());
            if (result) {
                event.setCanceled(true);
                event.setCancellationResult(EnumActionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() == null) {
            return;
        }
        PlayerAether playerAether = PlayerAether.getPlayer(event.getHarvester());
        ItemStack stack = event.getHarvester().func_184586_b(EnumHand.MAIN_HAND);
        if (stack.func_190926_b() && playerAether.getLastDestroyedStack() != null) {
            stack = playerAether.getLastDestroyedStack();
            playerAether.setLastDestroyedStack(null);
        }
        if (stack.func_77973_b() instanceof ItemTool) {
            String material = ((ItemTool)stack.func_77973_b()).func_77861_e();
            IToolEventHandler handler = handlers.get(material);
            if (handler == null) {
                return;
            }
            handler.onHarvestBlock(stack, event.getWorld(), event.getState(), event.getPos(), event.getHarvester(), event.getDrops());
        }
    }

    @SubscribeEvent
    public static void onItemDestroyed(PlayerDestroyItemEvent event) {
        if (event.getEntityPlayer() == null) {
            return;
        }
        PlayerAether playerAether = PlayerAether.getPlayer(event.getEntityPlayer());
        if (event.getOriginal().func_77973_b() instanceof ItemTool) {
            playerAether.setLastDestroyedStack(event.getOriginal());
        }
    }

    public static float getBreakSpeed(ItemStack stack, IBlockState state, float original) {
        String material = ((ItemTool)stack.func_77973_b()).func_77861_e();
        IToolEventHandler handler = handlers.get(material);
        if (handler != null) {
            return handler.getBreakSpeed(stack, state, original);
        }
        return original;
    }

    @SubscribeEvent
    public static void onEntityHit(AttackEntityEvent event) {
        ItemStack stack = event.getEntityLiving().func_184586_b(EnumHand.MAIN_HAND);
        if (stack.func_77973_b() instanceof ItemTool) {
            String material = ((ItemTool)stack.func_77973_b()).func_77861_e();
            IToolEventHandler handler = handlers.get(material);
            if (handler == null) {
                return;
            }
            handler.onEntityHit(stack, event.getTarget(), event.getEntityLiving());
        }
    }

    public static boolean onEntityHit(ItemStack stack, Item.ToolMaterial material, EntityLivingBase target, EntityLivingBase attacker) {
        IToolEventHandler handler = handlers.get(material.name());
        if (handler != null) {
            handler.onEntityHit(stack, (Entity)target, attacker);
        }
        return true;
    }

    static {
        handlers.put(MaterialsAether.SKYROOT_TOOL.name(), new ItemSkyrootToolHandler());
        handlers.put(MaterialsAether.HOLYSTONE_TOOL.name(), new ItemHolystoneToolHandler());
        handlers.put(MaterialsAether.ARKENIUM_TOOL.name(), new ItemArkeniumToolHandler());
        handlers.put(MaterialsAether.ZANITE_TOOL.name(), new ItemZaniteToolHandler());
        handlers.put(MaterialsAether.GRAVITITE_TOOL.name(), new ItemGravititeToolHandler());
    }
}

