/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.events.listeners.items;

import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.CompatibilityAether;
import com.gildedgames.aether.common.blocks.construction.BlockAetherPortal;
import com.gildedgames.aether.common.init.DimensionsAether;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ItemBucketEventListener {
    @SubscribeEvent
    public static void onPlayerUseBucket(FillBucketEvent event) {
        if (event.getTarget() != null && event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK) {
            boolean hasWaterFluid;
            FluidStack fluidStack = null;
            if (event.getEmptyBucket().hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                fluidStack = FluidUtil.getFluidContained((ItemStack)event.getEmptyBucket());
            }
            EntityPlayer player = event.getEntityPlayer();
            BlockPos pos = event.getTarget().func_178782_a().func_177972_a(event.getTarget().field_178784_b);
            boolean bl = hasWaterFluid = fluidStack != null && fluidStack.getFluid().getName().equals(FluidRegistry.WATER.getName());
            if (hasWaterFluid || event.getEmptyBucket().func_77973_b() == Items.field_151131_as || event.getEmptyBucket().func_77973_b() == ItemsAether.skyroot_water_bucket) {
                IBlockState targetState = event.getWorld().func_180495_p(event.getTarget().func_178782_a());
                if (targetState.func_177230_c() == Blocks.field_150426_aN) {
                    if (!CompatibilityAether.isAetherLegacyInstalled() && ItemBucketEventListener.isPortalFrame(event.getWorld(), event.getTarget().func_178782_a(), pos)) {
                        event.setCanceled(true);
                        player.openGui((Object)"aether", 11, player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    }
                } else if (targetState.func_177230_c() == Blocks.field_150371_ca) {
                    ItemBucketEventListener.onPlayerAttemptPortalCreation(event, player, pos);
                }
            }
        }
    }

    private static boolean isPortalFrame(World world, BlockPos target, BlockPos pos) {
        IBlockState state = world.func_180495_p(target);
        if (state.func_177230_c() == Blocks.field_150371_ca || state.func_177230_c() == Blocks.field_150426_aN) {
            BlockAetherPortal.Size size = new BlockAetherPortal.Size(world, pos, EnumFacing.Axis.X);
            if (size.isWithinSizeBounds() && size.getPortalBlocks() == 0 && size.isPortalBase(state)) {
                return true;
            }
            size = new BlockAetherPortal.Size(world, pos, EnumFacing.Axis.Z);
            return size.isWithinSizeBounds() && size.getPortalBlocks() == 0 && size.isPortalBase(state);
        }
        return false;
    }

    private static void onPlayerAttemptPortalCreation(FillBucketEvent event, EntityPlayer player, BlockPos pos) {
        if (player.field_70170_p.field_73011_w.func_186058_p() == DimensionsAether.AETHER) {
            return;
        }
        if (ItemBucketEventListener.createPortal(event.getWorld(), event.getTarget().func_178782_a(), pos)) {
            if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)event.getEmptyBucket());
                ItemStack stack = ItemStack.field_190927_a;
                if (fluidHandler != null) {
                    FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)event.getEmptyBucket(), (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)true);
                    stack = result.getResult();
                }
                if (event.getEmptyBucket().func_77973_b() == Items.field_151131_as) {
                    stack = new ItemStack(Items.field_151133_ar);
                }
                if (event.getEmptyBucket().func_77973_b() == ItemsAether.skyroot_water_bucket) {
                    stack = new ItemStack(ItemsAether.skyroot_bucket);
                }
                event.getEntityPlayer().field_71071_by.func_70299_a(event.getEntityPlayer().field_71071_by.field_70461_c, stack);
            }
            event.setCanceled(true);
        }
    }

    private static boolean createPortal(World world, BlockPos target, BlockPos pos) {
        BlockAetherPortal.Size size = new BlockAetherPortal.Size(world, pos, EnumFacing.Axis.X);
        if (size.isWithinSizeBounds() && size.getPortalBlocks() == 0 && size.isPortalBase(world.func_180495_p(target))) {
            size.createPortal();
            return true;
        }
        size = new BlockAetherPortal.Size(world, pos, EnumFacing.Axis.Z);
        if (size.isWithinSizeBounds() && size.getPortalBlocks() == 0 && size.isPortalBase(world.func_180495_p(target))) {
            size.createPortal();
            return true;
        }
        return false;
    }
}

