/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.events.listeners.items;

import com.gildedgames.aether.api.entity.damage.IDefenseLevelsHolder;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffectPool;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffects;
import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.items.armor.ItemAetherShield;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class ItemAetherShieldListener {
    @SubscribeEvent
    public static void onEntityAttacked(LivingAttackEvent event) {
        Vec3d vec3d;
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (!event.getSource().func_76363_c() && player.func_184585_cz() && (vec3d = event.getSource().func_188404_v()) != null) {
            Vec3d look = player.func_70676_i(1.0f);
            Vec3d reverse = vec3d.func_72444_a(new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v)).func_72432_b();
            reverse = new Vec3d(reverse.field_72450_a, 0.0, reverse.field_72449_c);
            if (reverse.func_72430_b(look) < 0.0) {
                float damage = event.getAmount();
                if (player.func_184607_cu().func_77973_b() instanceof ItemShield || player.func_184607_cu().func_77973_b() instanceof ItemAetherShield) {
                    IAetherStatusEffectPool statusEffectPool = (IAetherStatusEffectPool)player.getCapability(CapabilitiesAether.STATUS_EFFECT_POOL, null);
                    int buildup = 0;
                    if (player.func_184607_cu().func_77973_b() instanceof ItemAetherShield) {
                        ItemAetherShield itemAetherShield = (ItemAetherShield)player.func_184607_cu().func_77973_b();
                        buildup = (int)((double)((int)damage * 5) * (1.0 - itemAetherShield.getStunResistance()));
                    } else if (player.func_184607_cu().func_77973_b() instanceof ItemShield) {
                        buildup = (int)damage * 5;
                    }
                    if (event.getSource().func_76364_f() instanceof IDefenseLevelsHolder && statusEffectPool != null) {
                        if (!statusEffectPool.isEffectApplied(IAetherStatusEffects.effectTypes.GUARD_BREAK)) {
                            statusEffectPool.applyStatusEffect(IAetherStatusEffects.effectTypes.GUARD_BREAK, buildup);
                        } else {
                            statusEffectPool.modifyActiveEffectBuildup(IAetherStatusEffects.effectTypes.GUARD_BREAK, statusEffectPool.getBuildupFromEffect(IAetherStatusEffects.effectTypes.GUARD_BREAK) + buildup);
                        }
                    }
                    if (damage >= 3.0f) {
                        int itemDamage = 1 + MathHelper.func_76141_d((float)damage);
                        player.func_184607_cu().func_77972_a(itemDamage, (EntityLivingBase)player);
                        if (player.func_184607_cu().func_190916_E() <= 0) {
                            EnumHand hand = player.func_184600_cs();
                            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)player.func_184607_cu(), (EnumHand)hand);
                            if (hand == EnumHand.MAIN_HAND) {
                                player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                            } else {
                                player.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                            }
                            player.func_184611_a(player.func_184600_cs(), ItemStack.field_190927_a);
                            player.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerBlockStart(LivingEntityUseItemEvent.Start event) {
        IAetherStatusEffectPool statusEffectPool;
        if ((event.getItem().func_77973_b() instanceof ItemAetherShield || event.getItem().func_77973_b() instanceof ItemShield) && event.getEntityLiving() != null && (statusEffectPool = (IAetherStatusEffectPool)event.getEntityLiving().getCapability(CapabilitiesAether.STATUS_EFFECT_POOL, null)) != null && statusEffectPool.isEffectApplied(IAetherStatusEffects.effectTypes.GUARD_BREAK)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerBlock(LivingEntityUseItemEvent.Tick event) {
        IAetherStatusEffectPool statusEffectPool;
        if ((event.getItem().func_77973_b() instanceof ItemAetherShield || event.getItem().func_77973_b() instanceof ItemShield) && event.getEntityLiving() != null && (statusEffectPool = (IAetherStatusEffectPool)event.getEntityLiving().getCapability(CapabilitiesAether.STATUS_EFFECT_POOL, null)) != null) {
            for (IAetherStatusEffects effect : statusEffectPool.getPool().values()) {
                if (effect.getEffectType() != IAetherStatusEffects.effectTypes.GUARD_BREAK) continue;
                if (event.getItem().func_190916_E() > 0) {
                    effect.adjustDecrease(0);
                } else {
                    effect.resetDecrease();
                }
                if (!statusEffectPool.isEffectApplied(IAetherStatusEffects.effectTypes.GUARD_BREAK)) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerBlockStop(LivingEntityUseItemEvent.Stop event) {
        IAetherStatusEffectPool statusEffectPool;
        if ((event.getItem().func_77973_b() instanceof ItemAetherShield || event.getItem().func_77973_b() instanceof ItemShield) && event.getEntityLiving() != null && (statusEffectPool = (IAetherStatusEffectPool)event.getEntityLiving().getCapability(CapabilitiesAether.STATUS_EFFECT_POOL, null)) != null) {
            for (IAetherStatusEffects effect : statusEffectPool.getPool().values()) {
                if (effect.getEffectType() != IAetherStatusEffects.effectTypes.GUARD_BREAK) continue;
                effect.resetDecrease();
            }
        }
    }

    @SubscribeEvent
    public static void onEffectExist(TickEvent.PlayerTickEvent event) {
        IAetherStatusEffectPool statusEffectPool;
        if (event.player != null && (statusEffectPool = (IAetherStatusEffectPool)event.player.getCapability(CapabilitiesAether.STATUS_EFFECT_POOL, null)) != null) {
            for (IAetherStatusEffects effect : statusEffectPool.getPool().values()) {
                if (effect.getEffectType() != IAetherStatusEffects.effectTypes.GUARD_BREAK || event.player.func_184614_ca().func_77973_b() instanceof ItemAetherShield || event.player.func_184592_cb().func_77973_b() instanceof ItemAetherShield || event.player.func_184614_ca().func_77973_b() instanceof ItemShield || event.player.func_184592_cb().func_77973_b() instanceof ItemShield) continue;
                effect.resetDecrease();
            }
        }
    }

    @SubscribeEvent
    public static void onSkyrootBlock(TickEvent.PlayerTickEvent event) {
        UUID SHIELD_UUID = UUID.fromString("8A4950B1-D935-4E22-BAEE-0715A104300D");
        AttributeModifier SHIELD_BLOCK = new AttributeModifier(SHIELD_UUID, "aether.statusBlockingSkyrootShield", 1.05, 1);
        IAttributeInstance shieldSlowedLevel = event.player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (event.player.func_184607_cu().func_77973_b() != ItemsAether.skyroot_shield) {
            if (shieldSlowedLevel.func_111127_a(SHIELD_BLOCK.func_111167_a()) != null) {
                shieldSlowedLevel.func_111124_b(SHIELD_BLOCK);
            }
        } else if (!shieldSlowedLevel.func_180374_a(SHIELD_BLOCK)) {
            shieldSlowedLevel.func_111121_a(SHIELD_BLOCK);
        }
    }

    @SubscribeEvent
    public static void onArkeniumBlock(TickEvent.PlayerTickEvent event) {
        UUID SHIELD_UUID = UUID.fromString("CB4C4DF3-B0C6-4156-9793-CF46A1DD6116");
        AttributeModifier SHIELD_BLOCK = new AttributeModifier(SHIELD_UUID, "aether.statusBlockingArkeniumShield", -1.0, 1);
        IAttributeInstance shieldSlowedLevel = event.player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (event.player.func_184607_cu().func_77973_b() != ItemsAether.arkenium_shield) {
            if (shieldSlowedLevel.func_111127_a(SHIELD_BLOCK.func_111167_a()) != null) {
                shieldSlowedLevel.func_111124_b(SHIELD_BLOCK);
            }
        } else if (!shieldSlowedLevel.func_180374_a(SHIELD_BLOCK)) {
            shieldSlowedLevel.func_111121_a(SHIELD_BLOCK);
        }
    }

    @SubscribeEvent
    public static void onGravititeBlock(TickEvent.PlayerTickEvent event) {
        UUID SHIELD_UUID = UUID.fromString("21594E31-3DF3-47CE-9263-6D1D4E75CB70");
        AttributeModifier SHIELD_BLOCK = new AttributeModifier(SHIELD_UUID, "aether.statusBlockingGravititeShield", -0.2, 1);
        IAttributeInstance shieldSlowedLevel = event.player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (event.player.func_184607_cu().func_77973_b() != ItemsAether.gravitite_shield) {
            if (shieldSlowedLevel.func_111127_a(SHIELD_BLOCK.func_111167_a()) != null) {
                shieldSlowedLevel.func_111124_b(SHIELD_BLOCK);
            }
        } else if (!shieldSlowedLevel.func_180374_a(SHIELD_BLOCK)) {
            shieldSlowedLevel.func_111121_a(SHIELD_BLOCK);
        }
    }
}

