/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.util.groups;

import com.gildedgames.aether.common.entities.util.groups.EntityGroupAggressor;
import com.gildedgames.aether.common.entities.util.groups.EntityGroupMember;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;

public class EntityGroup {
    private static final Map<Integer, EntityGroup> packs = new HashMap<Integer, EntityGroup>();
    private static int nextPackID = Integer.MIN_VALUE;
    final List<EntityGroupAggressor> agressors = new ArrayList<EntityGroupAggressor>();
    int tickCounter = 0;
    private int size;
    private int id;
    private int optimalSize;
    private boolean hasLeader;

    public EntityGroup() {
    }

    public EntityGroup(int id) {
        this.id = id;
    }

    public static int getNextID() {
        return nextPackID++;
    }

    public static void onUpdate() {
        for (EntityGroup pack : packs.values()) {
            ++pack.tickCounter;
            pack.removeDeadAndOldAgressors();
        }
    }

    public int getID() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
        this.refresh();
    }

    public int getOptimalSize() {
        return this.optimalSize;
    }

    public void setOptimalSize(int size) {
        this.optimalSize = size;
        this.refresh();
    }

    public boolean hasLeader() {
        return this.hasLeader;
    }

    public void onAnimalDeath(EntityGroupMember groupEntity) {
        if (groupEntity.isGroupLeader()) {
            this.hasLeader = false;
        }
        --this.size;
        this.refresh();
    }

    public void onAnimalJoin(EntityGroupMember groupEntity) {
        if (groupEntity.isGroupLeader()) {
            this.hasLeader = true;
        }
        ++this.size;
        this.refresh();
    }

    public void addOrRenewAggressor(EntityLivingBase entity) {
        EntityGroupAggressor agressor;
        Iterator<EntityGroupAggressor> iterator = this.agressors.iterator();
        do {
            if (!iterator.hasNext()) {
                this.agressors.add(new EntityGroupAggressor(this, entity, this.tickCounter));
                return;
            }
            agressor = iterator.next();
        } while (agressor.agressor != entity);
        agressor.time = this.tickCounter;
    }

    public EntityLivingBase findNearestAggressor(EntityLivingBase entity) {
        double d0 = Double.MAX_VALUE;
        EntityGroupAggressor agressor = null;
        for (EntityGroupAggressor agressor1 : this.agressors) {
            double d1 = agressor1.agressor.func_70068_e((Entity)entity);
            if (!(d1 <= d0)) continue;
            agressor = agressor1;
            d0 = d1;
        }
        return agressor != null ? agressor.agressor : null;
    }

    private void removeDeadAndOldAgressors() {
        Iterator<EntityGroupAggressor> iterator = this.agressors.iterator();
        while (iterator.hasNext()) {
            EntityGroupAggressor agressor = iterator.next();
            if (agressor.agressor.func_70089_S() && this.tickCounter - agressor.time <= 2200) continue;
            iterator.remove();
        }
    }

    private void refresh() {
        packs.put(this.id, this);
    }

    public boolean equals(Object object) {
        if (!(object instanceof EntityGroup)) {
            return false;
        }
        EntityGroup pack = (EntityGroup)object;
        return pack.getID() == this.getID();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("packID", this.id);
        nbt.func_74768_a("optimalPackSize", this.optimalSize);
        nbt.func_74768_a("size", this.size);
        nbt.func_74768_a("nextPackID", nextPackID);
        nbt.func_74768_a("tickCounter", this.tickCounter);
        nbt.func_74757_a("hasLeader", this.hasLeader);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.id = nbt.func_74762_e("packID");
        this.optimalSize = nbt.func_74762_e("optimalPackSize");
        this.size = nbt.func_74762_e("size");
        nextPackID = nbt.func_74762_e("nextPackID");
        this.hasLeader = nbt.func_74767_n("hasLeader");
        this.tickCounter = nbt.func_74762_e("tickCounter");
        this.refresh();
    }
}

