/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.tiles.multiblock;

import com.gildedgames.aether.api.world.IWorldObjectHoverable;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.entities.tiles.TileEntitySynced;
import com.gildedgames.aether.common.entities.tiles.multiblock.ITileEntityMultiblock;
import com.gildedgames.aether.common.entities.tiles.multiblock.TileEntityMultiblockController;
import com.gildedgames.orbis.lib.util.mc.NBTHelper;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class TileEntityMultiblockDummy
extends TileEntitySynced
implements ITileEntityMultiblock,
IWorldObjectHoverable {
    private BlockPos controllerPosOffset;

    @Override
    public boolean onInteract(EntityPlayer player) {
        BlockPos linked = this.getLinkedController();
        if (linked != null) {
            TileEntity entity = this.field_145850_b.func_175625_s(linked);
            if (entity instanceof TileEntityMultiblockController) {
                ((ITileEntityMultiblock)entity).onInteract(player);
                return true;
            }
            AetherCore.LOGGER.warn("TileEntityMultiblockDummy at " + this.field_174879_c.toString() + ", is missing it's linked controller at " + linked.toString());
        }
        return false;
    }

    @Override
    public void onDestroyed() {
        BlockPos linked = this.getLinkedController();
        if (linked == null) {
            return;
        }
        TileEntity entity = this.field_145850_b.func_175625_s(linked);
        if (entity instanceof ITileEntityMultiblock) {
            ((ITileEntityMultiblock)entity).onDestroyed();
        } else {
            AetherCore.LOGGER.warn("TileEntityMultiblockDummy at " + this.field_174879_c.toString() + ", is missing it's linked controller at " + this.getLinkedController().toString());
        }
    }

    @Override
    public ItemStack getPickedStack(World world, BlockPos pos, IBlockState state) {
        BlockPos linked = this.getLinkedController();
        if (linked == null) {
            return ItemStack.field_190927_a;
        }
        TileEntity entity = this.field_145850_b.func_175625_s(linked);
        if (entity instanceof ITileEntityMultiblock) {
            return ((ITileEntityMultiblock)entity).getPickedStack(world, pos, state);
        }
        AetherCore.LOGGER.warn("TileEntityMultiblockDummy at " + this.field_174879_c.toString() + ", is missing it's linked controller at " + this.getLinkedController().toString());
        return ItemStack.field_190927_a;
    }

    protected void linkController(BlockPos controllerPos) {
        this.controllerPosOffset = controllerPos.func_177982_a(-this.field_174879_c.func_177958_n(), -this.field_174879_c.func_177956_o(), -this.field_174879_c.func_177952_p());
    }

    @Nullable
    protected BlockPos getLinkedController() {
        if (this.controllerPosOffset == null) {
            return null;
        }
        return this.field_174879_c.func_177971_a((Vec3i)this.controllerPosOffset);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("controller")) {
            this.controllerPosOffset = NBTHelper.readBlockPos((NBTTagCompound)compound.func_74775_l("controller"));
        } else {
            this.func_145843_s();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.controllerPosOffset != null) {
            compound.func_74782_a("controller", NBTHelper.writeBlockPos((BlockPos)this.controllerPosOffset));
        }
        return compound;
    }

    @Override
    public ITextComponent getHoverText(World world, RayTraceResult result) {
        BlockPos linked = this.getLinkedController();
        if (linked == null) {
            return null;
        }
        TileEntity entity = this.field_145850_b.func_175625_s(linked);
        if (entity instanceof IWorldObjectHoverable) {
            return ((IWorldObjectHoverable)entity).getHoverText(world, result);
        }
        return null;
    }
}

