/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.tiles.multiblock;

import com.gildedgames.aether.common.blocks.multiblock.BlockMultiController;
import com.gildedgames.aether.common.entities.tiles.TileEntitySynced;
import com.gildedgames.aether.common.entities.tiles.multiblock.ITileEntityMultiblock;
import com.gildedgames.aether.common.entities.tiles.multiblock.TileEntityMultiblockDummy;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityMultiblockController
extends TileEntitySynced
implements ITileEntityMultiblock {
    private final BlockMultiController block;
    private final Block dummy;

    public TileEntityMultiblockController(BlockMultiController block, Block dummy) {
        this.block = block;
        this.dummy = dummy;
    }

    public void rebuild() {
        for (BlockPos.MutableBlockPos pos : this.block.getMultiblockVolumeIterator(this.field_174879_c, this.func_145831_w())) {
            if (this.field_174879_c.equals((Object)pos)) continue;
            this.field_145850_b.func_180501_a((BlockPos)pos, this.dummy.func_176223_P(), 3);
            this.field_145850_b.func_184138_a((BlockPos)pos, Blocks.field_150350_a.func_176223_P(), this.dummy.func_176223_P(), 2);
            TileEntityMultiblockDummy te = (TileEntityMultiblockDummy)this.field_145850_b.func_175625_s((BlockPos)pos);
            te.linkController(new BlockPos((Vec3i)this.field_174879_c));
        }
    }

    @Override
    public void onDestroyed() {
        for (BlockPos.MutableBlockPos pos : this.block.getMultiblockVolumeIterator(this.field_174879_c, this.func_145831_w())) {
            if (!this.doesControllerOwn((BlockPos)pos)) continue;
            this.field_145850_b.func_175713_t((BlockPos)pos);
            this.field_145850_b.func_175698_g((BlockPos)pos);
        }
    }

    private boolean doesControllerOwn(BlockPos pos) {
        TileEntity entity = this.field_145850_b.func_175625_s(pos);
        if (entity instanceof TileEntityMultiblockController) {
            return true;
        }
        if (entity instanceof TileEntityMultiblockDummy) {
            TileEntityMultiblockDummy dummy = (TileEntityMultiblockDummy)entity;
            return Objects.equals(dummy.getLinkedController(), this.field_174879_c);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        Iterable<BlockPos.MutableBlockPos> itPos = this.block.getMultiblockVolumeIterator(this.field_174879_c, this.field_145850_b);
        BlockPos min = this.field_174879_c;
        BlockPos max = this.field_174879_c;
        for (BlockPos.MutableBlockPos pos : itPos) {
            max = pos;
        }
        return new AxisAlignedBB(min, max.func_177982_a(1, 1, 1));
    }
}

