/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.tiles;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.world.IWorldObjectHoverable;
import com.gildedgames.aether.client.events.listeners.gui.GuiLoadingListener;
import com.gildedgames.aether.common.ConfigAether;
import com.gildedgames.aether.common.blocks.containers.BlockAltar;
import com.gildedgames.aether.common.blocks.multiblock.BlockMultiController;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerConfigModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerTeleportingModule;
import com.gildedgames.aether.common.entities.tiles.multiblock.TileEntityMultiblockController;
import com.gildedgames.aether.common.events.PostAetherTravelEvent;
import com.gildedgames.aether.common.init.DimensionsAether;
import com.gildedgames.aether.common.init.InstancesAether;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.PacketSetPlayedIntro;
import com.gildedgames.aether.common.util.helpers.AetherHelper;
import com.gildedgames.aether.common.world.instances.necromancer_tower.NecromancerTowerInstanceHelper;
import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.util.TeleporterGeneric;
import com.gildedgames.orbis.lib.util.mc.BlockPosDimension;
import com.gildedgames.orbis.lib.world.instances.IInstance;
import com.gildedgames.orbis.lib.world.instances.IPlayerInstances;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTeleporter
extends TileEntityMultiblockController
implements ITickable,
IWorldObjectHoverable {
    @SideOnly(value=Side.CLIENT)
    public int animationTicks;
    @SideOnly(value=Side.CLIENT)
    public int prevAnimationTicks;
    private int buildTime;

    public TileEntityTeleporter() {
        super((BlockMultiController)BlocksAether.aether_teleporter, BlocksAether.multiblock_dummy);
    }

    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == BlocksAether.aether_teleporter) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockAltar.PROPERTY_FACING);
        }
        return EnumFacing.NORTH;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.prevAnimationTicks = this.animationTicks++;
        }
        this.buildTime = this.buildTime < 200 ? ++this.buildTime : 0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.buildTime = compound.func_74762_e("BuildTime");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BuildTime", (int)((short)this.buildTime));
        return compound;
    }

    public int getBuildTime() {
        return this.buildTime;
    }

    @Override
    public boolean onInteract(EntityPlayer player) {
        if (player.field_70170_p.field_73011_w.func_186058_p() == DimensionsAether.AETHER) {
            if (player instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                PlayerAether playerAether = PlayerAether.getPlayer(player);
                PlayerTeleportingModule teleportingModule = playerAether.getModule(PlayerTeleportingModule.class);
                teleportingModule.setAetherPos(new BlockPosDimension((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, player.field_71093_bK));
                BlockPosDimension nonAetherPos = teleportingModule.getNonAetherPos();
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                TeleporterGeneric teleporter = new TeleporterGeneric(server.func_71218_a(player.field_71093_bK));
                PlayerList playerList = server.func_184103_al();
                playerList.transferPlayerToDimension(playerMP, nonAetherPos.getDim(), (Teleporter)teleporter);
                player.field_71088_bW = player.func_82147_ab();
                playerMP.field_71135_a.func_147364_a((double)nonAetherPos.func_177958_n(), (double)nonAetherPos.func_177956_o(), (double)nonAetherPos.func_177952_p(), 0.0f, 0.0f);
            }
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            PlayerAether playerAether = PlayerAether.getPlayer(player);
            PlayerTeleportingModule teleportingModule = playerAether.getModule(PlayerTeleportingModule.class);
            if (ConfigAether.skipIntro) {
                teleportingModule.setPlayedIntro(true);
                NetworkingAether.sendPacketToServer(new PacketSetPlayedIntro(true));
            }
            if (!teleportingModule.hasPlayedIntro()) {
                GuiLoadingListener.setDrawBlackScreen(true);
            } else {
                GuiLoadingListener.setDrawLoading(true);
            }
            return true;
        }
        NecromancerTowerInstanceHelper handler = InstancesAether.NECROMANCER_TOWER_HANDLER;
        PlayerAether playerAether = PlayerAether.getPlayer(player);
        PlayerTeleportingModule teleportingModule = playerAether.getModule(PlayerTeleportingModule.class);
        IPlayerInstances hook = OrbisLib.instances().getPlayer(player);
        if (teleportingModule.getAetherPos() != null) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            BlockPosDimension p = teleportingModule.getAetherPos();
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (!ForgeHooks.onTravelToDimension((Entity)playerMP, (int)p.getDim())) {
                return false;
            }
            TeleporterGeneric teleporter = new TeleporterGeneric(server.func_71218_a(player.field_71093_bK));
            PlayerList playerList = server.func_184103_al();
            playerList.transferPlayerToDimension(playerMP, p.getDim(), (Teleporter)teleporter);
            player.field_71088_bW = player.func_82147_ab();
            playerMP.field_71135_a.func_147364_a((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), 225.0f, 0.0f);
            PostAetherTravelEvent event = new PostAetherTravelEvent((Entity)playerMP);
            MinecraftForge.EVENT_BUS.post((Event)event);
        } else if (hook.getInstance() != null) {
            IInstance instance = hook.getInstance();
            if (player.field_71093_bK == instance.getDimensionId()) {
                handler.teleportBack((EntityPlayerMP)player);
            } else {
                hook.setInstance(null);
                handler.teleportToInst((EntityPlayerMP)player);
            }
        } else if (playerAether.getModule(PlayerConfigModule.class).skipIntro()) {
            teleportingModule.teleportToAether();
        } else {
            handler.teleportToInst((EntityPlayerMP)player);
        }
        return true;
    }

    @Override
    public ItemStack getPickedStack(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(BlocksAether.aether_teleporter);
    }

    @Override
    public ITextComponent getHoverText(World world, RayTraceResult result) {
        return new TextComponentTranslation(AetherHelper.isAether(world) ? "gui.aether.hover.campfire" : "gui.aether.hover.teleporter", new Object[0]);
    }
}

