/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.tiles;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.world.IWorldObjectHoverable;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.blocks.multiblock.BlockMultiController;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerCampfiresModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerSwetTrackerModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerTeleportingModule;
import com.gildedgames.aether.common.entities.tiles.multiblock.TileEntityMultiblockController;
import com.gildedgames.aether.common.init.DimensionsAether;
import com.gildedgames.orbis.lib.util.TeleporterGeneric;
import com.gildedgames.orbis.lib.util.mc.BlockPosDimension;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityOutpostCampfire
extends TileEntityMultiblockController
implements ITickable,
IWorldObjectHoverable {
    private static final int PLAYER_SEARCHING_RADIUS = 2;
    private BlockPosDimension posDim;

    public TileEntityOutpostCampfire() {
        super((BlockMultiController)BlocksAether.outpost_campfire, BlocksAether.multiblock_dummy_half);
    }

    @Override
    public boolean onInteract(EntityPlayer player) {
        if (player instanceof EntityPlayerMP && player.field_70170_p.field_73011_w.func_186058_p() == DimensionsAether.AETHER) {
            if (!player.func_184218_aH() && !player.func_184207_aI() && PlayerAether.getPlayer(player).getModule(PlayerSwetTrackerModule.class).getLatchedSwets().isEmpty()) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                PlayerAether playerAether = PlayerAether.getPlayer(player);
                PlayerTeleportingModule teleportingModule = playerAether.getModule(PlayerTeleportingModule.class);
                teleportingModule.setAetherPos(new BlockPosDimension((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, player.field_71093_bK));
                BlockPosDimension pos = teleportingModule.getNonAetherPos();
                if (pos == null) {
                    pos = new BlockPosDimension(DimensionManager.getWorld((int)0).func_175694_M(), 0);
                }
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                TeleporterGeneric teleporter = new TeleporterGeneric(server.func_71218_a(player.field_71093_bK));
                PlayerList playerList = server.func_184103_al();
                playerList.transferPlayerToDimension(playerMP, pos.getDim(), (Teleporter)teleporter);
                player.field_71088_bW = player.func_82147_ab();
                playerMP.field_71135_a.func_147364_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                return true;
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.aether.campfire.mobNotification", new Object[0]), true);
        }
        return false;
    }

    @Override
    public ItemStack getPickedStack(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(BlocksAether.outpost_campfire);
    }

    @SideOnly(value=Side.CLIENT)
    public void clientUpdate() {
        PlayerAether playerAether = PlayerAether.getPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        PlayerCampfiresModule campfiresModule = playerAether.getModule(PlayerCampfiresModule.class);
        if (campfiresModule.hasCampfire(this.posDim)) {
            AetherCore.PROXY.spawnCampfireParticles(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 1.0, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 1.0);
        }
    }

    public void func_73660_a() {
        if (this.posDim == null) {
            this.posDim = new BlockPosDimension(this.field_174879_c, this.field_145850_b.field_73011_w.getDimension());
        }
        AxisAlignedBB searchingBB = new AxisAlignedBB(new BlockPos(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p() - 2), new BlockPos((double)((float)(this.field_174879_c.func_177958_n() + 2) + 2.0f), (double)(this.field_174879_c.func_177956_o() + 2), (double)((float)(this.field_174879_c.func_177952_p() + 2) + 2.0f)));
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, searchingBB);
        if (this.field_145850_b.field_72995_K) {
            this.clientUpdate();
        }
        for (EntityPlayer player : players) {
            PlayerAether playerAether = PlayerAether.getPlayer(player);
            PlayerCampfiresModule campfiresModule = playerAether.getModule(PlayerCampfiresModule.class);
            if (campfiresModule.hasCampfire(this.posDim)) continue;
            campfiresModule.addActivatedCampfire(this.posDim);
            AetherCore.PROXY.spawnCampfireStartParticles(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 1.0, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 1.0);
        }
    }

    @Override
    public ITextComponent getHoverText(World world, RayTraceResult result) {
        return new TextComponentTranslation("gui.aether.hover.campfire", new Object[0]);
    }
}

