/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.tiles;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.common.entities.animals.EntityMoa;
import com.gildedgames.aether.common.entities.genes.AnimalGender;
import com.gildedgames.aether.common.entities.genes.SimpleGeneStorage;
import com.gildedgames.aether.common.entities.genes.moa.MoaGenePool;
import com.gildedgames.aether.common.entities.genes.moa.MoaNest;
import com.gildedgames.aether.common.entities.tiles.TileEntitySynced;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class TileEntityMoaEgg
extends TileEntitySynced
implements ITickable {
    public int ticksExisted;
    public int secondsUntilHatch = -1;
    public MoaNest familyNest;
    public boolean playerPlaced;
    public AnimalGender gender = AnimalGender.FEMALE;
    private final MoaGenePool genePool = new MoaGenePool(new SimpleGeneStorage());

    public TileEntityMoaEgg() {
        this.familyNest = new MoaNest(this.field_145850_b);
    }

    public MoaGenePool getGenePool() {
        return this.genePool;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.playerPlaced) {
            return;
        }
        if (this.secondsUntilHatch <= -1) {
            this.secondsUntilHatch = 100 + this.field_145850_b.field_73012_v.nextInt(100);
        }
        ++this.ticksExisted;
        if (this.ticksExisted % 20 == 0) {
            if (this.secondsUntilHatch > 0) {
                --this.secondsUntilHatch;
            } else if (this.hatchConditionsMet()) {
                this.hatchEgg();
            }
        }
    }

    public boolean hatchConditionsMet() {
        boolean atMaxFamilySize = this.familyNest.getAnimalPack() != null && this.familyNest.getAnimalPack().getSize() >= this.familyNest.getAnimalPack().getOptimalSize();
        return this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(0, -1, 0)) == BlocksAether.woven_sticks.func_176223_P() && !atMaxFamilySize;
    }

    public void hatchEgg() {
        EntityMoa babyMoa = new EntityMoa(this.field_145850_b, this.familyNest, this.genePool.getStorage().getFatherSeed(), this.genePool.getStorage().getMotherSeed());
        babyMoa.func_70873_a(-24000);
        babyMoa.func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5, this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5);
        babyMoa.setGender(this.gender);
        babyMoa.setAnimalPack(this.familyNest.getAnimalPack());
        this.field_145850_b.func_72838_d((Entity)babyMoa);
        this.field_145850_b.func_175655_b(this.func_174877_v(), false);
    }

    public AnimalGender getGender() {
        return this.gender;
    }

    public void setGender(AnimalGender gender) {
        this.gender = gender;
    }

    public void setFamilyNest(MoaNest familyNest) {
        this.familyNest = familyNest;
    }

    public void setPlayerPlaced() {
        this.playerPlaced = true;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.genePool.read(nbt.func_74775_l("genePool"));
        this.secondsUntilHatch = nbt.func_74762_e("secondsUntilHatch");
        this.gender = AnimalGender.get(nbt.func_74779_i("creatureGender"));
        this.familyNest.readFromNBT(nbt);
        this.playerPlaced = nbt.func_74767_n("playerPlaced");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagCompound genePoolTag = new NBTTagCompound();
        this.genePool.write(genePoolTag);
        nbt.func_74782_a("genePool", (NBTBase)genePoolTag);
        nbt.func_74768_a("secondsUntilHatch", this.secondsUntilHatch);
        if (this.gender != null) {
            nbt.func_74778_a("creatureGender", this.gender.name());
        }
        this.familyNest.writeToNBT(nbt);
        nbt.func_74757_a("playerPlaced", this.playerPlaced);
        return nbt;
    }
}

