/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.tiles;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.blocks.containers.BlockIcestoneCooler;
import com.gildedgames.aether.common.blocks.containers.BlockIncubator;
import com.gildedgames.aether.common.containers.tiles.ContainerIncubator;
import com.gildedgames.aether.common.entities.animals.EntityMoa;
import com.gildedgames.aether.common.entities.genes.AnimalGender;
import com.gildedgames.aether.common.entities.genes.moa.MoaGenePool;
import com.gildedgames.aether.common.entities.genes.moa.MoaNest;
import com.gildedgames.aether.common.items.other.ItemMoaEgg;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityIncubator
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_EAST = new int[]{1};
    private static final int[] SLOTS_WEST = new int[]{0};
    private NonNullList<ItemStack> incubatorItemStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private int incubationTimeMax = 1600;
    private int incubationTime;
    private int heatingTimeMax = 800;
    private int heatingTime;
    private String incubatorCustomName;
    private final IItemHandler handlerEast = new SidedInvWrapper((ISidedInventory)this, EnumFacing.EAST);
    private final IItemHandler handlerWest = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);
    private final IItemHandler handlerNone = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);

    public static boolean isItemEgg(ItemStack stack) {
        return stack.func_77973_b() == ItemsAether.moa_egg_item || stack.func_77973_b() == ItemsAether.rainbow_moa_egg;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return stack.func_77973_b() == ItemsAether.ambrosium_chunk || stack.func_77973_b() == ItemsAether.irradiated_dust;
    }

    public int func_70302_i_() {
        return this.incubatorItemStacks.size();
    }

    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == BlocksAether.icestone_cooler) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockIcestoneCooler.PROPERTY_FACING);
        }
        return EnumFacing.NORTH;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.incubatorItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.incubatorItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.incubatorItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.incubatorItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.incubatorItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.incubatorItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.incubationTime = 0;
            this.func_70296_d();
            this.sendUpdatesToClients();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            this.sendUpdatesToClients();
            this.setCustomInventoryName(this.incubatorCustomName);
        }
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return TileEntityIncubator.isItemFuel(stack);
        }
        if (index == 1) {
            return TileEntityIncubator.isItemEgg(stack);
        }
        return false;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.incubationTimeMax;
            }
            case 1: {
                return this.incubationTime;
            }
            case 2: {
                return this.heatingTimeMax;
            }
            case 3: {
                return this.heatingTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.incubationTimeMax = value;
                break;
            }
            case 1: {
                this.incubationTime = value;
                break;
            }
            case 2: {
                this.heatingTimeMax = value;
                break;
            }
            case 3: {
                this.heatingTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.incubatorItemStacks.clear();
    }

    public void func_73660_a() {
        boolean isHeating = this.isHeating();
        boolean isIncubating = this.isIncubating();
        boolean flag = false;
        boolean isHeatTimerOn = false;
        if (!this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            ItemStack fuelStack = (ItemStack)this.incubatorItemStacks.get(0);
            ItemStack eggStack = (ItemStack)this.incubatorItemStacks.get(1);
            if (isHeating) {
                this.heatingTime = this.heatingTime < this.heatingTimeMax ? ++this.heatingTime : 0;
                flag = true;
            }
            if (!fuelStack.func_190926_b()) {
                if (!eggStack.func_190926_b()) {
                    ++this.incubationTime;
                    ++this.heatingTime;
                } else {
                    this.incubationTime = 0;
                }
                if (this.heatingTime >= this.heatingTimeMax) {
                    fuelStack.func_190918_g(1);
                    this.heatingTime = 0;
                }
                flag = true;
                isHeatTimerOn = true;
            }
            if (!eggStack.func_190926_b()) {
                if (isIncubating && this.incubationTime >= this.incubationTimeMax) {
                    Random rand = new Random();
                    MoaGenePool stackGenes = ItemMoaEgg.getGenePool(eggStack);
                    MoaNest familyNest = new MoaNest(this.field_145850_b);
                    EntityMoa moa = new EntityMoa(this.field_145850_b, stackGenes.getStorage().getSeed());
                    moa.setRaisedByPlayer(true);
                    moa.func_70873_a(-24000);
                    moa.setFoodRequired(3);
                    moa.func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.5, (double)this.func_174877_v().func_177952_p() + 0.5);
                    moa.setGender(rand.nextBoolean() ? AnimalGender.FEMALE : AnimalGender.MALE);
                    moa.setAnimalPack(familyNest.getAnimalPack());
                    moa.setIsHungry(true);
                    this.field_145850_b.func_72838_d((Entity)moa);
                    eggStack.func_190918_g(1);
                    this.incubationTime = 0;
                }
                if (isHeatTimerOn && fuelStack.func_190926_b() && this.heatingTime == 0) {
                    eggStack.func_190918_g(1);
                    this.incubationTime = 0;
                }
                flag = true;
            }
            if (state.func_177230_c() instanceof BlockIncubator && (Boolean)state.func_177229_b((IProperty)BlockIncubator.PROPERTY_IS_LIT) != isHeating) {
                this.func_70296_d();
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockIncubator.PROPERTY_IS_LIT, (Comparable)Boolean.valueOf(this.isHeating())));
                this.func_145829_t();
                this.field_145850_b.func_175690_a(this.field_174879_c, (TileEntity)this);
            }
        }
        if (flag) {
            this.func_70296_d();
            this.sendUpdatesToClients();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isIncubating(IInventory inventory) {
        return inventory.func_174887_a_(1) > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isHeating(IInventory inventory) {
        return inventory.func_174887_a_(3) > 0;
    }

    public boolean isIncubating() {
        return this.incubationTime > 0;
    }

    public boolean isHeating() {
        return this.heatingTime > 0;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerIncubator(playerInventory, (IInventory)this);
    }

    public String func_174875_k() {
        return "aether:incubator";
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.incubatorCustomName : "container.incubator";
    }

    public boolean func_145818_k_() {
        return this.incubatorCustomName != null && !this.incubatorCustomName.isEmpty();
    }

    public void setCustomInventoryName(String p_145951_1_) {
        this.incubatorCustomName = p_145951_1_;
    }

    public void sendUpdatesToClients() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.func_70296_d();
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.func_189515_b(tag);
        return tag;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, compound);
    }

    public void onDataPacket(NetworkManager networkManager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.incubatorItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.incubatorItemStacks);
        this.incubationTime = compound.func_74762_e("incubationTime");
        this.heatingTime = compound.func_74762_e("heatingTime");
        if (compound.func_150297_b("CustomName", 8)) {
            this.incubatorCustomName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("incubationTime", (int)((short)this.incubationTime));
        compound.func_74768_a("heatingTime", (int)((short)this.heatingTime));
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.incubatorItemStacks);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.incubatorCustomName);
        }
        return compound;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.EAST || side == EnumFacing.SOUTH ? SLOTS_EAST : (side == EnumFacing.WEST || side == EnumFacing.NORTH ? SLOTS_WEST : new int[]{});
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.EAST || facing == EnumFacing.SOUTH) {
                return (T)this.handlerEast;
            }
            if (facing == EnumFacing.WEST || facing == EnumFacing.NORTH) {
                return (T)this.handlerWest;
            }
            return (T)this.handlerNone;
        }
        return (T)super.getCapability(capability, facing);
    }
}

