/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.tiles;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.blocks.containers.BlockIcestoneCooler;
import com.gildedgames.aether.common.containers.tiles.ContainerIcestoneCooler;
import com.gildedgames.aether.common.recipes.CoolerRecipes;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityIcestoneCooler
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{2, 4};
    private static final int[] SLOTS_EAST = new int[]{3};
    private static final int[] SLOTS_WEST = new int[]{1};
    private final int totalCoolTime = 800;
    private final int itemCoolTime = 1600;
    private NonNullList<ItemStack> coolerItemStacks = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private int coolerCoolTime;
    private int currentItemCoolTime;
    private int coolTime;
    private String coolerCustomName;
    private final IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    private final IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    private final IItemHandler handlerEast = new SidedInvWrapper((ISidedInventory)this, EnumFacing.EAST);
    private final IItemHandler handlerWest = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    @SideOnly(value=Side.CLIENT)
    public static boolean isCooling(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public static boolean isItemCooling(ItemStack stack) {
        return stack.func_77973_b() == ItemsAether.icestone;
    }

    public static boolean isItemIrradiated(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == ItemsAether.irradiated_chunk || item == ItemsAether.irradiated_armor || item == ItemsAether.irradiated_charm || item == ItemsAether.irradiated_neckwear || item == ItemsAether.irradiated_ring || item == ItemsAether.irradiated_sword || item == ItemsAether.irradiated_tool;
    }

    public int func_70302_i_() {
        return this.coolerItemStacks.size();
    }

    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == BlocksAether.icestone_cooler) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockIcestoneCooler.PROPERTY_FACING);
        }
        return EnumFacing.NORTH;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.coolerItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.coolerItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.coolerItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.coolerItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.coolerItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.coolerItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.coolTime = 0;
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
        this.sendUpdatesToClients();
        if (this.field_145850_b.field_72995_K) {
            this.sendUpdatesToClients();
            this.setCustomInventoryName(this.coolerCustomName);
        }
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2 || index == 4) {
            return false;
        }
        if (index == 0 || index == 3) {
            return true;
        }
        if (index == 1) {
            return TileEntityIcestoneCooler.isItemCooling(stack);
        }
        return false;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.coolerCoolTime;
            }
            case 1: {
                return this.currentItemCoolTime;
            }
            case 2: {
                return this.coolTime;
            }
            case 3: {
                return this.totalCoolTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.coolerCoolTime = value;
                break;
            }
            case 1: {
                this.currentItemCoolTime = value;
                break;
            }
            case 2: {
                this.coolTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.coolerItemStacks.clear();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public void func_73660_a() {
        boolean flag = this.isCooling();
        boolean flag1 = false;
        this.sendUpdatesToClients();
        this.setCustomInventoryName(this.coolerCustomName);
        if (this.isCooling()) {
            --this.coolerCoolTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.coolerItemStacks.get(1);
            if (this.isCooling() || !itemstack.func_190926_b() && !((ItemStack)this.coolerItemStacks.get(0)).func_190926_b()) {
                if (!this.isCooling() && this.canCool()) {
                    this.currentItemCoolTime = this.coolerCoolTime = this.itemCoolTime;
                    if (this.isCooling()) {
                        flag1 = true;
                        if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(itemstack);
                                this.coolerItemStacks.set(1, (Object)item1);
                            }
                        }
                    }
                }
                if (this.isCooling() && this.canCool()) {
                    ++this.coolTime;
                    if (this.coolTime == this.totalCoolTime) {
                        this.coolTime = 0;
                        this.coolItem();
                        flag1 = true;
                    }
                } else {
                    this.coolTime = 0;
                }
            } else if (!this.isCooling() && this.coolTime > 0) {
                this.coolTime = MathHelper.func_76125_a((int)(this.coolTime - 2), (int)0, (int)this.totalCoolTime);
            }
            if (flag != this.isCooling()) {
                flag1 = true;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerIcestoneCooler(playerInventory, (IInventory)this);
    }

    public String func_174875_k() {
        return "aether:coooler";
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.coolerCustomName : "container.icestone_cooler";
    }

    public boolean func_145818_k_() {
        return this.coolerCustomName != null && !this.coolerCustomName.isEmpty();
    }

    public void setCustomInventoryName(String p_145951_1_) {
        this.coolerCustomName = p_145951_1_;
    }

    public void sendUpdatesToClients() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.func_70296_d();
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.func_189515_b(tag);
        return tag;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, compound);
    }

    public void onDataPacket(NetworkManager networkManager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.coolerItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.coolerItemStacks);
        this.coolerCoolTime = compound.func_74762_e("coolerCoolTime");
        this.coolTime = compound.func_74762_e("coolTime");
        if (compound.func_150297_b("CustomName", 8)) {
            this.coolerCustomName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("coolerCoolTime", (int)((short)this.coolerCoolTime));
        compound.func_74768_a("coolTime", (int)((short)this.coolTime));
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.coolerItemStacks);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.coolerCustomName);
        }
        return compound;
    }

    public boolean isCooling() {
        return this.coolerCoolTime > 0;
    }

    private boolean canCool() {
        ItemStack stackSlot0 = (ItemStack)this.coolerItemStacks.get(0);
        ItemStack stackSlot2 = (ItemStack)this.coolerItemStacks.get(2);
        ItemStack stackSlot3 = (ItemStack)this.coolerItemStacks.get(3);
        ItemStack stackSlot4 = (ItemStack)this.coolerItemStacks.get(4);
        ItemStack primaryOutput = CoolerRecipes.instance().getCoolingResult(stackSlot0, stackSlot3);
        ItemStack secondaryOutput = CoolerRecipes.instance().getSecondaryOutput(stackSlot0);
        if (stackSlot0.func_190926_b()) {
            return false;
        }
        if (primaryOutput.func_190926_b()) {
            return false;
        }
        if (!stackSlot4.func_190926_b() && stackSlot4.func_77973_b() != secondaryOutput.func_77973_b()) {
            return false;
        }
        if (stackSlot2.func_190926_b()) {
            return true;
        }
        if (!stackSlot2.func_77969_a(primaryOutput)) {
            return false;
        }
        int result = stackSlot2.func_190916_E() + primaryOutput.func_190916_E();
        return result <= this.func_70297_j_() && result <= stackSlot2.func_77976_d();
    }

    public int getCoolTime(ItemStack stack) {
        return this.totalCoolTime;
    }

    public void coolItem() {
        if (this.canCool()) {
            ItemStack stackSlot0 = (ItemStack)this.coolerItemStacks.get(0);
            ItemStack stackSlot2 = (ItemStack)this.coolerItemStacks.get(2);
            ItemStack stackSlot3 = (ItemStack)this.coolerItemStacks.get(3);
            ItemStack stackSlot4 = (ItemStack)this.coolerItemStacks.get(4);
            ItemStack secondaryInput = CoolerRecipes.instance().getSecondaryInput(stackSlot0);
            ItemStack primaryOutput = CoolerRecipes.instance().getCoolingResult(stackSlot0, stackSlot3);
            ItemStack secondaryOutput = CoolerRecipes.instance().getSecondaryOutput(stackSlot0);
            if (stackSlot2.func_190926_b()) {
                this.coolerItemStacks.set(2, (Object)primaryOutput.func_77946_l());
            } else if (stackSlot2.func_77973_b() == primaryOutput.func_77973_b()) {
                stackSlot2.func_190917_f(primaryOutput.func_190916_E());
            }
            if (secondaryOutput != null) {
                if (stackSlot4.func_190926_b()) {
                    this.coolerItemStacks.set(4, (Object)secondaryOutput.func_77946_l());
                } else if (stackSlot4.func_77973_b() == secondaryOutput.func_77973_b()) {
                    stackSlot4.func_190917_f(1);
                }
            }
            if (secondaryInput != ItemStack.field_190927_a && stackSlot3.func_77973_b() == secondaryInput.func_77973_b()) {
                stackSlot3.func_190918_g(1);
            }
            stackSlot0.func_190918_g(1);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : (side == EnumFacing.EAST || side == EnumFacing.SOUTH ? SLOTS_EAST : SLOTS_WEST));
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            if (facing == EnumFacing.EAST || facing == EnumFacing.SOUTH) {
                return (T)this.handlerEast;
            }
            if (facing == EnumFacing.WEST || facing == EnumFacing.NORTH) {
                return (T)this.handlerWest;
            }
        }
        return (T)super.getCapability(capability, facing);
    }
}

