/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.tiles;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.recipes.altar.IAltarRecipe;
import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.blocks.containers.BlockAltar;
import com.gildedgames.aether.common.entities.tiles.TileEntitySynced;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityAltar
extends TileEntitySynced
implements ITickable {
    @SideOnly(value=Side.CLIENT)
    public double animationTicks;
    @SideOnly(value=Side.CLIENT)
    public double prevAnimationTicks;
    private ItemStack stackOnAltar = ItemStack.field_190927_a;
    private int ambrosiumCount;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.prevAnimationTicks = this.animationTicks;
            this.animationTicks += 1.0;
        }
    }

    @Nonnull
    public ItemStack getStackOnAltar() {
        return this.stackOnAltar;
    }

    public void setStackOnAltar(@Nonnull ItemStack stack) {
        this.stackOnAltar = stack;
        this.sendUpdatesToClients();
    }

    public int getAmbrosiumCount() {
        return this.ambrosiumCount;
    }

    public void setAmbrosiumCount(int count) {
        this.ambrosiumCount = count;
        this.sendUpdatesToClients();
    }

    public void removeAmbrosiumShard() {
        this.setAmbrosiumCount(this.getAmbrosiumCount() - 1);
    }

    public void addAmbrosiumShard() {
        this.setAmbrosiumCount(this.getAmbrosiumCount() + 1);
    }

    public void attemptCrafting() {
        IAltarRecipe recipe;
        if (!this.getStackOnAltar().func_190926_b() && this.getAmbrosiumCount() > 0 && (recipe = AetherAPI.content().altar().getMatchingRecipeFromInput(this.getStackOnAltar())) != null) {
            int cost = recipe.getAmbrosiumCost(this.getStackOnAltar());
            if (this.getAmbrosiumCount() >= cost) {
                ItemStack stack = recipe.getOutput(this.getStackOnAltar());
                this.func_145831_w().func_72838_d((Entity)this.createEntityItemAboveAltar(stack));
                this.ambrosiumCount -= cost;
                this.setStackOnAltar(ItemStack.field_190927_a);
            }
        }
    }

    public void dropContents() {
        if (this.getAmbrosiumCount() > 0) {
            ItemStack stack = new ItemStack(ItemsAether.ambrosium_shard, this.getAmbrosiumCount());
            this.func_145831_w().func_72838_d((Entity)this.createEntityItemAboveAltar(stack));
        }
        if (!this.getStackOnAltar().func_190926_b()) {
            this.func_145831_w().func_72838_d((Entity)this.createEntityItemAboveAltar(this.getStackOnAltar()));
        }
        this.setAmbrosiumCount(0);
        this.setStackOnAltar(ItemStack.field_190927_a);
    }

    public EntityItem createEntityItemAboveAltar(ItemStack stack) {
        return new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.1, (double)this.func_174877_v().func_177952_p() + 0.5, stack);
    }

    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == BlocksAether.altar) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockAltar.PROPERTY_FACING);
        }
        return EnumFacing.NORTH;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound itemCompound = new NBTTagCompound();
        if (this.stackOnAltar != null) {
            this.stackOnAltar.func_77955_b(itemCompound);
        }
        compound.func_74782_a("StackOnAltar", (NBTBase)itemCompound);
        compound.func_74768_a("AmbrosiumCount", this.ambrosiumCount);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagCompound itemCompound = compound.func_74775_l("StackOnAltar");
        this.stackOnAltar = itemCompound.func_82582_d() ? null : new ItemStack(itemCompound);
        this.ambrosiumCount = compound.func_74762_e("AmbrosiumCount");
    }
}

