/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.mounts;

import com.gildedgames.aether.api.entity.IMountProcessor;
import com.gildedgames.aether.common.entities.mounts.IFlyingMountData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class FlyingMount
implements IMountProcessor {
    private final IFlyingMountData data;

    public FlyingMount(IFlyingMountData data) {
        this.data = data;
    }

    public IFlyingMountData getData() {
        return this.data;
    }

    @Override
    public void onUpdate(Entity mount, Entity rider) {
        if (mount.field_70122_E) {
            this.data.resetRemainingAirborneTime();
        }
    }

    @Override
    public void onHoldSpaceBar(Entity mount, Entity rider) {
        if (mount.field_70122_E) {
            mount.field_70181_x = 0.55;
            this.data.resetRemainingAirborneTime();
        } else if (mount.field_70181_x < 0.1 && this.data.getRemainingAirborneTime() > 0.0f) {
            mount.field_70181_x = 0.1;
            this.data.addRemainingAirborneTime(-0.1f);
        }
    }

    @Override
    public float getMountedStepHeight(Entity mount) {
        return 1.0f;
    }

    @Override
    public boolean canBeMounted(Entity mount) {
        return this.data.canBeMounted();
    }

    @Override
    public boolean canProcessMountInteraction(Entity mount, Entity rider) {
        if (rider instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)rider;
            ItemStack stack = player.func_184614_ca();
            return this.data.canProcessMountInteraction(player, stack);
        }
        return false;
    }

    @Override
    public void onMountedBy(Entity mount, Entity rider) {
        if (mount instanceof EntityLivingBase) {
            ((EntityLivingBase)mount).func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        }
    }

    @Override
    public void onDismountedBy(Entity mount, Entity rider) {
        if (mount instanceof EntityLivingBase) {
            ((EntityLivingBase)mount).func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        }
    }
}

