/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.monsters;

import com.gildedgames.aether.api.entity.damage.DamageTypeAttributes;
import com.gildedgames.aether.api.entity.effects.EEffectIntensity;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffectIntensity;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffects;
import com.gildedgames.aether.common.entities.ai.EntityAIHideFromLight;
import com.gildedgames.aether.common.entities.ai.EntityAIUnstuckBlueAercloud;
import com.gildedgames.aether.common.entities.ai.EntityAIWanderAvoidLight;
import com.gildedgames.aether.common.entities.effects.StatusEffectFreeze;
import com.gildedgames.aether.common.entities.monsters.EntityAetherMob;
import com.gildedgames.aether.common.entities.multipart.AetherMultiPartEntity;
import com.gildedgames.aether.common.util.helpers.MathUtil;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Point3d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityVaranys
extends EntityAetherMob
implements IEntityMultiPart {
    protected Map<String, Float> defenseMap = Maps.newHashMap();
    private final MultiPartEntityPart[] parts;
    private final MultiPartEntityPart head;
    private final MultiPartEntityPart tail1;
    private final MultiPartEntityPart tail2;
    private final EntityAIHideFromLight lightAI;
    private final Point3d[] old;

    public EntityVaranys(World world) {
        super(world);
        this.defenseMap.put("Very Weak", Float.valueOf(4.0f));
        this.defenseMap.put("Weak", Float.valueOf(2.0f));
        this.defenseMap.put("Average", Float.valueOf(0.0f));
        this.defenseMap.put("Strong", Float.valueOf(-2.0f));
        this.defenseMap.put("Very Strong", Float.valueOf(-4.0f));
        this.head = new AetherMultiPartEntity(this, "head", 0.7f, 0.7f);
        this.tail1 = new AetherMultiPartEntity(this, "tail", 1.0f, 0.7f);
        this.tail2 = new AetherMultiPartEntity(this, "tail2", 1.0f, 0.7f);
        this.lightAI = new EntityAIHideFromLight((EntityCreature)this, 0.8f, 5);
        this.parts = new MultiPartEntityPart[]{this.head, this.tail1, this.tail2};
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIUnstuckBlueAercloud((EntityCreature)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.lightAI);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWanderAvoidLight((EntityCreature)this, 0.8, 5));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.func_70105_a(1.4f, 1.0f);
        this.field_70138_W = 1.0f;
        this.head.func_82142_c(true);
        this.tail1.func_82142_c(true);
        this.tail2.func_82142_c(true);
        this.field_70728_aV = 7;
        this.old = new Point3d[this.parts.length];
        for (int i = 0; i < this.old.length; ++i) {
            this.old[i] = new Point3d();
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111128_a(0.0);
        this.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111128_a(-4.0);
        this.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111128_a(2.0);
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        switch (part.field_146032_b) {
            case "head": {
                damage *= 1.05f;
                break;
            }
            default: {
                damage *= 0.7f;
            }
        }
        if (this.field_70172_ad <= 10) {
            return this.func_70097_a(source, damage);
        }
        return false;
    }

    public World func_82194_d() {
        return this.func_130014_f_();
    }

    @Nullable
    public MultiPartEntityPart[] getParts() {
        return this.parts;
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag = super.func_70652_k(entity);
        if (flag && entity instanceof EntityLivingBase) {
            this.applyStatusEffectOnAttack(entity);
        }
        return flag;
    }

    @Override
    protected void applyStatusEffectOnAttack(Entity target) {
        EntityLivingBase living;
        if (target instanceof EntityLivingBase && !(living = (EntityLivingBase)target).func_184585_cz()) {
            int buildup = IAetherStatusEffectIntensity.getBuildupFromEffect(new StatusEffectFreeze(living), EEffectIntensity.MAJOR);
            IAetherStatusEffects.applyStatusEffect(living, IAetherStatusEffects.effectTypes.FREEZE, buildup);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.lightAI.setEnabled(this.func_70638_az() == null);
        this.setMultiPartLocations();
    }

    private void setMultiPartLocations() {
        for (int i = 0; i < this.parts.length; ++i) {
            this.old[i].set(this.parts[i].field_70165_t, this.parts[i].field_70163_u, this.parts[i].field_70161_v);
        }
        float f = MathUtil.interpolateRotation(this.field_70760_ar, this.field_70761_aq, 1.0f);
        float f1 = MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180) - (float)Math.PI));
        this.head.func_70071_h_();
        this.head.func_70012_b(this.field_70165_t - (double)f2, this.field_70163_u + 0.25, this.field_70161_v - (double)f1, 0.0f, 0.0f);
        this.tail1.func_70071_h_();
        this.tail1.func_70012_b(this.field_70165_t + (double)(f2 * 1.1f), this.field_70163_u + 0.25, this.field_70161_v + (double)(f1 * 1.1f), 0.0f, 0.0f);
        this.tail2.func_70071_h_();
        this.tail2.func_70012_b(this.field_70165_t + (double)(f2 * 2.0f), this.field_70163_u, this.field_70161_v + (double)(f1 * 2.0f), 0.0f, 0.0f);
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].field_70169_q = this.old[i].getX();
            this.parts[i].field_70167_r = this.old[i].getY();
            this.parts[i].field_70166_s = this.old[i].getZ();
        }
    }
}

