/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.monsters;

import com.gildedgames.aether.api.entity.damage.DamageTypeAttributes;
import com.gildedgames.aether.api.entity.damage.IDefenseLevelsHolder;
import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerSwetTrackerModule;
import com.gildedgames.aether.common.entities.ai.EntityAIRestrictRain;
import com.gildedgames.aether.common.entities.ai.hopping.AIHopFloat;
import com.gildedgames.aether.common.entities.ai.hopping.AIHopFollowAttackTarget;
import com.gildedgames.aether.common.entities.ai.hopping.AIHopHideFromRain;
import com.gildedgames.aether.common.entities.ai.hopping.AIHopWander;
import com.gildedgames.aether.common.entities.ai.hopping.HoppingMoveHelper;
import com.gildedgames.aether.common.entities.ai.swet.AILatchOn;
import com.gildedgames.aether.common.entities.util.EntityExtendedMob;
import com.gildedgames.aether.common.init.LootTablesAether;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.PacketDetachSwet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySwet
extends EntityExtendedMob
implements IDefenseLevelsHolder {
    protected Map<String, Float> defenseMap = Maps.newHashMap();
    public static final int FOOD_SATURATION_REQUIRED = 5;
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntitySwet.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FOOD_SATURATION = EntityDataManager.func_187226_a(EntitySwet.class, (DataSerializer)DataSerializers.field_187192_b);
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;
    private float squishPoolSize;
    private float actualSaturation;
    private int timeSinceSucking;
    private int digestTime;
    private int timeStarved;
    private int transitionTime;

    public EntitySwet(World worldIn) {
        super(worldIn);
        this.defenseMap.put("Very Weak", Float.valueOf(4.0f));
        this.defenseMap.put("Weak", Float.valueOf(2.0f));
        this.defenseMap.put("Average", Float.valueOf(0.0f));
        this.defenseMap.put("Strong", Float.valueOf(-2.0f));
        this.defenseMap.put("Very Strong", Float.valueOf(-4.0f));
        HoppingMoveHelper hoppingMoveHelper = new HoppingMoveHelper((EntityLiving)this, () -> this.getFoodSaturation() == 0 ? SoundEvents.field_187882_fq : SoundEvents.field_187882_fq, () -> this.func_70681_au().nextInt(this.getFoodSaturation() == 3 ? 10 : 60) + (this.getFoodSaturation() == 3 ? 40 : 50));
        this.field_70765_h = hoppingMoveHelper;
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictRain((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIHopHideFromRain((EntityCreature)this, hoppingMoveHelper, 1.3));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AILatchOn(this, hoppingMoveHelper));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIHopWander((EntityLiving)this, hoppingMoveHelper));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIHopFloat((EntityLiving)this, hoppingMoveHelper));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIHopFollowAttackTarget((EntityLiving)this, hoppingMoveHelper, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 10, true, false, e -> EntitySwet.canLatch(this, e)));
        this.func_70105_a(1.0f, 1.0f);
        if (this.field_70170_p != null) {
            this.setType(Type.values()[this.field_70170_p.field_73012_v.nextInt(Type.values().length)]);
            this.setFoodSaturation(3);
        }
        this.field_70728_aV = 3;
        this.actualSaturation = 3.0f;
        this.setDayMob(true);
    }

    public static boolean canLatch(EntitySwet swet, EntityPlayer player) {
        return !player.func_70090_H() && swet.getFoodSaturation() == 3 && PlayerAether.getPlayer(player).getModule(PlayerSwetTrackerModule.class).canLatchOn() && player.func_71024_bL().func_75116_a() > 4;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == BlocksAether.aether_grass ? 10.0f : this.field_70170_p.func_175724_o(pos) - 0.5f;
    }

    protected boolean func_70814_o() {
        return true;
    }

    public int getFoodSaturation() {
        return (Integer)this.field_70180_af.func_187225_a(FOOD_SATURATION);
    }

    public void setFoodSaturation(int foodSaturation) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(FOOD_SATURATION, (Object)foodSaturation);
        }
    }

    public boolean processSucking(EntityPlayer player) {
        PotionEffect slowness = new PotionEffect(Potion.func_188412_a((int)2), 3, this.timeSinceSucking / 80, true, false);
        player.func_70690_d(slowness);
        ++this.timeSinceSucking;
        if (this.timeSinceSucking % 40 == 0) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_71024_bL().func_75114_a((int)((float)player.func_71024_bL().func_75116_a() * 0.95f));
                Collection effects = player.func_70651_bq();
                if (!effects.isEmpty()) {
                    ArrayList<PotionEffect> negEffects = new ArrayList<PotionEffect>();
                    for (PotionEffect p : effects) {
                        if (!p.func_188419_a().func_76398_f()) continue;
                        negEffects.add(p);
                    }
                    for (PotionEffect p : negEffects) {
                        if (p.func_188419_a().equals(Potion.func_188412_a((int)2))) continue;
                        this.func_70690_d(p);
                        player.func_184589_d(p.func_188419_a());
                        if (p.func_76458_c() - 1 >= 0) {
                            player.func_70690_d(new PotionEffect(p.func_188419_a(), (int)((double)p.func_76459_b() * 0.75), p.func_76458_c() - 1));
                            continue;
                        }
                        if (p.func_76459_b() <= 60) continue;
                        player.func_70690_d(new PotionEffect(p.func_188419_a(), (int)((double)p.func_76459_b() * 0.75), p.func_76458_c()));
                    }
                }
            }
            player.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.2f + 1.0f);
        }
        if (!(this.timeSinceSucking < 300 && player.func_71024_bL().func_75116_a() > 0 || this.field_70170_p.field_72995_K)) {
            if (this.timeSinceSucking >= 220) {
                this.setFoodSaturation(4);
            }
            NetworkingAether.sendPacketToWatching(new PacketDetachSwet(this.getType(), player.func_145782_y()), (EntityLivingBase)player, true);
            return true;
        }
        return false;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
        this.field_70180_af.func_187214_a(FOOD_SATURATION, (Object)1);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111128_a(-2.0);
        this.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111128_a(0.0);
        this.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111128_a(2.0);
    }

    protected void func_70664_aZ() {
        if (this.func_70605_aq().func_75638_b() <= 0.0) {
            return;
        }
        this.field_70181_x = 0.42f;
        this.field_70160_al = true;
    }

    public int func_70646_bf() {
        return 0;
    }

    @Override
    public void func_70071_h_() {
        if (this.func_70090_H() || this.field_70170_p.func_72896_J() && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v))) {
            this.timeStarved = -this.field_70146_Z.nextInt(60);
            this.setFoodSaturation(0);
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70071_h_();
        if (this.func_70638_az() != null && this.func_70638_az() instanceof EntityPlayer && ((EntityPlayer)this.func_70638_az()).func_71024_bL().func_75116_a() < 5) {
            this.func_70624_b(null);
        }
        if (this.field_70122_E && !this.wasOnGround) {
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        if (this.field_70122_E) {
            this.squishPoolSize += 0.2f;
            if (this.squishPoolSize > 1.54f) {
                this.squishPoolSize = 1.54f;
            }
        } else {
            this.squishPoolSize -= 0.2f;
            if (this.squishPoolSize < 1.0f) {
                this.squishPoolSize = 1.0f;
            }
        }
        if (this.actualSaturation < (float)this.getFoodSaturation() && this.transitionTime > 20) {
            this.actualSaturation += 0.02f;
            if (this.actualSaturation > (float)this.getFoodSaturation()) {
                this.actualSaturation = this.getFoodSaturation();
                if (this.getFoodSaturation() < 3) {
                    this.transitionTime = 0;
                } else {
                    ((HoppingMoveHelper)this.func_70605_aq()).setActive(true);
                }
            }
        } else if (this.actualSaturation > (float)this.getFoodSaturation()) {
            this.actualSaturation -= 0.2f;
            if (this.actualSaturation < (float)this.getFoodSaturation()) {
                this.actualSaturation = this.getFoodSaturation();
            }
            if (this.field_70170_p.field_72995_K && this.getActualSaturation() != 0.0f) {
                float[] redColors = new float[]{0.486f, 0.45f, 0.411f};
                float[] greenColors = new float[]{0.439f, 0.686f, 0.654f};
                float[] blueColors = new float[]{0.67f, 0.819f, 0.525f};
                int type = this.getType().name.equals("purple") ? 0 : (this.getType().name.equals("blue") ? 1 : 2);
                float f1 = this.getActualSaturation() / 5.0f;
                for (int i = 0; i < 5 + this.field_70146_Z.nextInt(5); ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t - (double)f1 + (double)(this.field_70146_Z.nextFloat() * f1 * 2.0f), this.field_70163_u - (double)f1 + (double)(this.field_70146_Z.nextFloat() * f1 * 2.0f), this.field_70161_v - (double)f1 + (double)(this.field_70146_Z.nextFloat() * f1 * 2.0f), (double)redColors[type], (double)greenColors[type], (double)blueColors[type], new int[0]);
                }
            }
        } else {
            if (this.getFoodSaturation() < 3 && this.timeStarved >= 2400) {
                ((HoppingMoveHelper)this.func_70605_aq()).setActive(false);
                this.setFoodSaturation(this.getFoodSaturation() + 1);
            }
            ++this.transitionTime;
        }
        if (this.getFoodSaturation() < 3) {
            ++this.timeStarved;
            this.func_70624_b(null);
        } else if (this.getFoodSaturation() != 3) {
            this.timeStarved = 0;
        }
        if (this.getFoodSaturation() == 4) {
            this.func_70690_d(new PotionEffect(Potion.func_188412_a((int)2), 10, 2, true, false));
            ++this.digestTime;
            if (this.digestTime > 1200) {
                this.setFoodSaturation(3);
                this.digestTime = -this.field_70146_Z.nextInt(300);
            }
        }
        this.wasOnGround = this.field_70122_E;
        this.alterSquishAmount();
    }

    public void setSucking(int timeSucking) {
        this.timeSinceSucking = timeSucking;
    }

    public int getTimeSinceSucking() {
        return this.timeSinceSucking;
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    public Type getType() {
        return Type.fromOrdinal((Integer)this.field_70180_af.func_187225_a(TYPE));
    }

    public void setType(Type type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type.ordinal());
    }

    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        this.setType(Type.fromOrdinal(tag.func_74762_e("type")));
        this.timeSinceSucking = tag.func_74762_e("timeSinceSucking");
        this.setFoodSaturation(tag.func_74762_e("foodSaturation"));
        this.actualSaturation = this.getFoodSaturation();
    }

    public NBTTagCompound func_189511_e(NBTTagCompound tag) {
        super.func_189511_e(tag);
        tag.func_74768_a("type", this.getType().ordinal());
        tag.func_74768_a("timeSinceSucking", this.timeSinceSucking);
        tag.func_74768_a("foodSaturation", this.getFoodSaturation());
        return tag;
    }

    protected ResourceLocation func_184647_J() {
        if (this.getFoodSaturation() > 0) {
            switch (this.getType()) {
                case BLUE: {
                    return LootTablesAether.ENTITY_SWET_BLUE;
                }
                case GREEN: {
                    return LootTablesAether.ENTITY_SWET_GREEN;
                }
                case PURPLE: {
                    return LootTablesAether.ENTITY_SWET_PURPLE;
                }
            }
            return LootTablesAether.ENTITY_SWET;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSquishPool() {
        return this.squishPoolSize;
    }

    @SideOnly(value=Side.CLIENT)
    public float getActualSaturation() {
        return this.actualSaturation;
    }

    public static enum Type {
        BLUE("blue"),
        GREEN("green"),
        PURPLE("purple");

        public final String name;
        public final ResourceLocation texture_head;
        public final ResourceLocation texture_jelly;
        public final ResourceLocation left1;
        public final ResourceLocation left2;
        public final ResourceLocation right1;
        public final ResourceLocation right2;

        private Type(String name) {
            this.name = name;
            this.texture_head = AetherCore.getResource("textures/entities/swet/swet_head_" + this.name + ".png");
            this.texture_jelly = AetherCore.getResource("textures/entities/swet/swet_jelly_" + this.name + ".png");
            this.left1 = AetherCore.getResource("textures/gui/overlay/swet/" + this.name + "_left_1.png");
            this.left2 = AetherCore.getResource("textures/gui/overlay/swet/" + this.name + "_left_2.png");
            this.right1 = AetherCore.getResource("textures/gui/overlay/swet/" + this.name + "_right_1.png");
            this.right2 = AetherCore.getResource("textures/gui/overlay/swet/" + this.name + "_right_2.png");
        }

        public static Type fromOrdinal(int ordinal) {
            Type[] gummy;
            return gummy[ordinal > (gummy = Type.values()).length || ordinal < 0 ? 0 : ordinal];
        }
    }
}

