/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.monsters;

import com.gildedgames.aether.api.entity.damage.DamageTypeAttributes;
import com.gildedgames.aether.api.entity.effects.EEffectIntensity;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffectIntensity;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffects;
import com.gildedgames.aether.api.registrar.SoundsAether;
import com.gildedgames.aether.common.entities.ai.EntityAIUnstuckBlueAercloud;
import com.gildedgames.aether.common.entities.ai.cockatrice.EntityAICockatriceHide;
import com.gildedgames.aether.common.entities.ai.cockatrice.EntityAICockatriceSneakAttack;
import com.gildedgames.aether.common.entities.ai.cockatrice.EntityAICockatriceWander;
import com.gildedgames.aether.common.entities.effects.StatusEffectCockatriceVenom;
import com.gildedgames.aether.common.entities.monsters.EntityAetherMob;
import com.gildedgames.aether.common.init.LootTablesAether;
import com.gildedgames.aether.common.util.helpers.EntityUtil;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityCockatrice
extends EntityAetherMob {
    protected Map<String, Float> defenseMap = Maps.newHashMap();
    private static final DataParameter<Boolean> IS_HIDING = new DataParameter(16, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_HIDDEN = new DataParameter(17, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_ATTACKING = new DataParameter(18, DataSerializers.field_187198_h);

    public EntityCockatrice(World world) {
        super(world);
        this.defenseMap.put("Very Weak", Float.valueOf(4.0f));
        this.defenseMap.put("Weak", Float.valueOf(2.0f));
        this.defenseMap.put("Average", Float.valueOf(0.0f));
        this.defenseMap.put("Strong", Float.valueOf(-2.0f));
        this.defenseMap.put("Very Strong", Float.valueOf(-4.0f));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIUnstuckBlueAercloud((EntityCreature)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAICockatriceHide(this, EntityPlayer.class, 0.9));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICockatriceWander(this, 0.35));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAICockatriceSneakAttack(this, EntityPlayer.class));
        this.field_70767_i = new JumpHelperDisable((EntityLiving)this);
        this.func_70105_a(1.0f, 2.5f);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 7;
    }

    protected void func_70664_aZ() {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_HIDING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(IS_HIDDEN, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(IS_ATTACKING, (Object)Boolean.FALSE);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111128_a(-4.0);
        this.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111128_a(0.0);
        this.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111128_a(2.0);
    }

    public boolean func_70687_e(PotionEffect potionEffect) {
        return potionEffect.func_188419_a() != MobEffects.field_76436_u && super.func_70687_e(potionEffect);
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag = super.func_70652_k(entity);
        if (flag && entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            this.applyStatusEffectOnAttack(entity);
        }
        return flag;
    }

    @Override
    protected void applyStatusEffectOnAttack(Entity target) {
        EntityLivingBase living;
        if (target instanceof EntityLivingBase && !(living = (EntityLivingBase)target).func_184585_cz()) {
            int buildup = IAetherStatusEffectIntensity.getBuildupFromEffect(new StatusEffectCockatriceVenom(living), EEffectIntensity.ORDINARY);
            IAetherStatusEffects.applyStatusEffect(living, IAetherStatusEffects.effectTypes.COCKATRICE_VENOM, buildup);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        EntityUtil.despawnEntityDuringDaytime((EntityLivingBase)this);
    }

    protected SoundEvent func_184639_G() {
        return SoundsAether.cockatrice_ambient;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsAether.cockatrice_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsAether.cockatrice_death;
    }

    public boolean isHiding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_HIDING);
    }

    public void setHiding(boolean isHiding) {
        this.field_70180_af.func_187227_b(IS_HIDING, (Object)isHiding);
    }

    public boolean isHidden() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_HIDDEN);
    }

    public void setHidden(boolean isHidden) {
        this.field_70180_af.func_187227_b(IS_HIDDEN, (Object)isHidden);
    }

    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_ATTACKING);
    }

    public void setAttacking(boolean isAttacking) {
        this.field_70180_af.func_187227_b(IS_ATTACKING, (Object)isAttacking);
    }

    protected ResourceLocation func_184647_J() {
        return LootTablesAether.ENTITY_COCKATRICE;
    }

    public static class JumpHelperDisable
    extends EntityJumpHelper {
        public JumpHelperDisable(EntityLiving entityIn) {
            super(entityIn);
        }

        public void func_75660_a() {
        }

        public void func_75661_b() {
        }
    }
}

