/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.monsters;

import com.gildedgames.aether.api.entity.damage.DamageTypeAttributes;
import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.common.entities.ai.EntityAIAechorPlantAttack;
import com.gildedgames.aether.common.entities.monsters.EntityAetherMob;
import com.gildedgames.aether.common.init.LootTablesAether;
import com.gildedgames.aether.common.util.helpers.PlayerUtil;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAechorPlant
extends EntityAetherMob {
    protected Map<String, Float> defenseMap = Maps.newHashMap();
    private static final int MAX_PETALS = 10;
    private static final DataParameter<Boolean> CAN_SEE_PREY = new DataParameter(16, DataSerializers.field_187198_h);
    private static final DataParameter<Byte> PLANT_SIZE = new DataParameter(17, DataSerializers.field_187191_a);
    private static final DataParameter<Byte> PLANT_PETALS = new DataParameter(18, DataSerializers.field_187191_a);
    private boolean[] petals;
    @SideOnly(value=Side.CLIENT)
    public float sinage;
    @SideOnly(value=Side.CLIENT)
    public float prevSinage;
    private int poisonLeft;
    private int petalGrowTimer;

    public EntityAechorPlant(World world) {
        super(world);
        this.defenseMap.put("Very Weak", Float.valueOf(4.0f));
        this.defenseMap.put("Weak", Float.valueOf(2.0f));
        this.defenseMap.put("Average", Float.valueOf(0.0f));
        this.defenseMap.put("Strong", Float.valueOf(-2.0f));
        this.defenseMap.put("Very Strong", Float.valueOf(-4.0f));
        this.petalGrowTimer = 3000;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAechorPlantAttack((EntityCreature)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.func_70105_a(0.8f, 0.6f);
        this.setPoisonLeft(2);
        if (world != null && world.field_72995_K) {
            this.sinage = this.field_70146_Z.nextFloat() * 6.0f;
        }
        this.field_70728_aV = 3;
        Arrays.fill(this.petals, true);
    }

    public boolean[] getPetalsPresent() {
        return this.petals;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.petals = new boolean[10];
        Arrays.fill(this.petals, true);
        this.field_70180_af.func_187214_a(CAN_SEE_PREY, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(PLANT_SIZE, (Object)0);
        this.field_70180_af.func_187214_a(PLANT_PETALS, (Object)this.serializePlantPetals());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.setPlantSize(this.field_70146_Z.nextInt(3) + 1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111128_a(0.0);
        this.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111128_a(0.0);
        this.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111128_a(0.0);
    }

    public void func_70071_h_() {
        boolean isTargeting;
        super.func_70071_h_();
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        if (!this.field_70170_p.field_72995_K) {
            --this.petalGrowTimer;
            if (this.petalGrowTimer <= 0) {
                this.petalGrowTimer = 2400 + this.func_70681_au().nextInt(1600);
                int remainingPetals = this.getPetalCountInState(true);
                if (remainingPetals < 10) {
                    this.setPetalState(this.getRandomPetal(false), true);
                }
                this.func_70691_i((float)((double)Math.round((double)(this.func_110138_aP() / 10.0f) * 2.0) / 2.0));
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.tickAnimation();
            return;
        }
        boolean bl = isTargeting = this.func_70638_az() != null;
        if (this.canSeePrey() != isTargeting) {
            this.setCanSeePrey(isTargeting);
        }
        if (!this.canStayHere(new BlockPos((Entity)this))) {
            this.func_70606_j(0.0f);
        }
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        float prevHealth = this.func_110143_aJ();
        super.func_70665_d(damageSrc, damageAmount);
        if (this.func_110143_aJ() != prevHealth) {
            this.petalGrowTimer = 6000;
            if (!this.field_70170_p.field_72995_K) {
                int remainingPetals;
                int targetPetals = (int)Math.floor(this.func_110143_aJ() / this.func_110138_aP() * 10.0f);
                int damage = remainingPetals - targetPetals;
                Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)new ItemStack(ItemsAether.aechor_petal, damage / 2));
                for (remainingPetals = this.getPetalCountInState(true); remainingPetals > targetPetals; --remainingPetals) {
                    this.setPetalState(this.getRandomPetal(true), false);
                }
            }
        }
    }

    private int getRandomPetal(boolean state) {
        int total = this.getPetalCountInState(state);
        int nth = this.field_70146_Z.nextInt(total);
        int selected = -1;
        int k = 0;
        for (int i = 0; i < this.petals.length; ++i) {
            boolean present = this.petals[i];
            if (present != state) continue;
            if (k == nth) {
                selected = i;
                break;
            }
            ++k;
        }
        return selected;
    }

    private void setPetalState(int index, boolean state) {
        this.petals[index] = state;
        this.sendPetalUpdate();
    }

    private void sendPetalUpdate() {
        this.field_70180_af.func_187227_b(PLANT_PETALS, (Object)this.serializePlantPetals());
    }

    private int getPetalCountInState(boolean state) {
        int i = 0;
        for (boolean a : this.petals) {
            if (a != state) continue;
            ++i;
        }
        return i;
    }

    private boolean canStayHere(BlockPos pos) {
        if (this.field_70170_p.func_180495_p(pos).func_185917_h()) {
            return false;
        }
        IBlockState rootBlock = this.field_70170_p.func_180495_p(pos.func_177977_b());
        return rootBlock.func_177230_c() == BlocksAether.aether_grass || rootBlock.func_177230_c() == BlocksAether.aether_dirt || rootBlock.func_177230_c() == BlocksAether.highlands_snow_layer || rootBlock.func_177230_c() == BlocksAether.highlands_snow;
    }

    public void func_70653_a(Entity entity, float distance, double x, double y) {
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (type == MoverType.PISTON) {
            super.func_70091_d(type, x, y, z);
        }
    }

    protected ResourceLocation func_184647_J() {
        return LootTablesAether.ENTITY_AECHOR_PLANT;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.field_71075_bZ.field_75098_d && stack.func_77973_b() == ItemsAether.skyroot_bucket && this.getPoisonLeft() > 0) {
            PlayerUtil.fillBucketInHand(player, hand, stack, new ItemStack(ItemsAether.skyroot_poison_bucket));
            this.setPoisonLeft(this.getPoisonLeft() - 1);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void tickAnimation() {
        this.prevSinage = this.sinage;
        this.sinage = this.field_70737_aN > 0 ? (this.sinage += 0.5f) : (this.sinage += this.canSeePrey() ? 0.3f : 0.1f);
        float pie2 = 6.283186f;
        if (this.sinage > pie2) {
            this.sinage -= pie2;
            this.prevSinage -= pie2;
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("plantSize", this.getPlantSize());
        tagCompound.func_74768_a("poisonLeft", this.getPoisonLeft());
        tagCompound.func_74774_a("petals", this.serializePlantPetals());
        tagCompound.func_74768_a("petalGrowTimer", this.petalGrowTimer);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.setPlantSize(tagCompound.func_74762_e("plantSize"));
        this.setPoisonLeft(tagCompound.func_74762_e("poisonLeft"));
        if (tagCompound.func_74764_b("petals")) {
            this.deserializePlantPetals(tagCompound.func_74771_c("petals"));
        } else {
            Arrays.fill(this.petals, true);
        }
        this.petalGrowTimer = tagCompound.func_74762_e("petalGrowTimer");
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public boolean canSeePrey() {
        return (Boolean)this.field_70180_af.func_187225_a(CAN_SEE_PREY);
    }

    public void setCanSeePrey(boolean canSee) {
        this.field_70180_af.func_187227_b(CAN_SEE_PREY, (Object)canSee);
    }

    public int getPlantSize() {
        return ((Byte)this.field_70180_af.func_187225_a(PLANT_SIZE)).byteValue();
    }

    public void setPlantSize(int size) {
        this.field_70180_af.func_187227_b(PLANT_SIZE, (Object)((byte)size));
    }

    public int getPoisonLeft() {
        return this.poisonLeft;
    }

    public void setPoisonLeft(int poisonLeft) {
        this.poisonLeft = poisonLeft;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key == PLANT_PETALS) {
            this.deserializePlantPetals((Byte)this.field_70180_af.func_187225_a(PLANT_PETALS));
        }
    }

    private void deserializePlantPetals(byte val) {
        for (int i = 0; i < this.petals.length; ++i) {
            this.petals[i] = (val >>> i & 1) == 1;
        }
    }

    private byte serializePlantPetals() {
        byte val = 0;
        for (int i = 0; i < this.petals.length; ++i) {
            if (!this.petals[i]) continue;
            val = (byte)(val | 1 << i);
        }
        return val;
    }
}

