/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.genes.moa;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.common.entities.animals.EntityMoa;
import com.gildedgames.aether.common.entities.genes.AnimalGender;
import com.gildedgames.aether.common.entities.genes.GeneUtil;
import com.gildedgames.aether.common.entities.util.groups.EntityGroup;
import com.gildedgames.orbis.lib.util.mc.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MoaNest {
    public final World world;
    public BlockPos pos;
    public int familyGeneticSeed;
    public boolean hasInitialized;
    protected EntityGroup pack;

    public MoaNest(World world) {
        this.world = world;
        this.pack = new EntityGroup();
    }

    public MoaNest(World world, BlockPos pos) {
        this(world, pos, GeneUtil.getRandomSeed(world));
    }

    public MoaNest(World world, BlockPos pos, int familyGeneticSeed) {
        this(world);
        this.pos = pos;
        this.hasInitialized = true;
        this.familyGeneticSeed = familyGeneticSeed;
    }

    public boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return world.func_175623_d(pos) || block.isLeaves(state, (IBlockAccess)world, pos) || block == BlocksAether.aether_grass || block == BlocksAether.aether_dirt || block.func_176200_f((IBlockAccess)world, pos) || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151582_l;
    }

    public void spawnMoaFamily(World world, int initialSize, int optimalSize) {
        this.pack = new EntityGroup(EntityGroup.getNextID());
        this.pack.setOptimalSize(optimalSize);
        for (int amount = 0; amount < initialSize; ++amount) {
            EntityMoa moa = new EntityMoa(world, this);
            int modifier = world.field_73012_v.nextBoolean() ? 1 : -1;
            int scatterValue = world.field_73012_v.nextInt(2) * modifier;
            moa.func_70107_b(this.pos.func_177958_n() + scatterValue, this.pos.func_177956_o() + 1, this.pos.func_177952_p() + scatterValue);
            if (amount == 1) {
                moa.setGender(AnimalGender.MALE);
            }
            if (amount >= 2) {
                moa.func_70873_a(-24000);
            }
            moa.setAnimalPack(this.pack);
            world.func_72838_d((Entity)moa);
        }
    }

    public EntityGroup getAnimalPack() {
        return this.pack;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("pos", NBTHelper.writeBlockPos((BlockPos)this.pos));
        nbt.func_74768_a("familyGeneticSeed", this.familyGeneticSeed);
        nbt.func_74757_a("hasInitialized", this.hasInitialized);
        this.pack.writeToNBT(nbt);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.pos = NBTHelper.readBlockPos((NBTTagCompound)nbt.func_74775_l("pos"));
        this.familyGeneticSeed = nbt.func_74762_e("familyGeneticSeed");
        this.hasInitialized = nbt.func_74767_n("hasInitialized");
        this.pack.readFromNBT(nbt);
    }
}

